% Optical flow by correlation
% d: max displacement ot search for
% w: window size 2w+1 
function  FlowCorr(inputimage1,inputimage2,d,w)

% Load images and display
I1=imread(inputimage1,'bmp');
I2=imread(inputimage2,'bmp');

%convert to greylevel
if(ndims(I1)==3)
    I1=rgb2gray(I1); end

if(ndims(I2)==3)
    I2=rgb2gray(I2); end


figure(1);
subplot(1,2,1); imshow(I1);

subplot(1,2,2); imshow(I2);

% image size
[rows,columns]=size(I1);  % I2 must have the same size

% result image
u=zeros(rows,columns);
v=zeros(rows,columns);

% correlation for each pixel
for x1=w+d+1:columns-w-d
	for y1=w+d+1:rows-w-d
		min=99999; dx=0; dy=0;
		% desplacement position
		for x2=x1-d:x1+d
	 		for y2=y1-d:y1+d
	  		sum=0; 
	  	  % window
	  		for i=-w:w
	  			for j=-w:w
	  				sum=sum+abs(double(I1(y1+j,x1+i))-double(I2(y2+j,x2+i)));
	 				end
	 			end 
	 
	 			if (sum<min)
	 				min=sum;
	 				dx=x2-x1; dy=y2-y1;
	 			end
	 		end
	 	end
	 	u(y1,x1)=dx;
	 	v(y1,x1)=dy;			
	end
end

% display result
%low dimension
a=3;
r=round(rows/a);
c=round(columns/a);
uu=zeros(r,c);
vv=zeros(r,c);
for x1=1:c
	for y1=1:r
	  uu(y1,x1)=u(y1*a-a+1,x1*a-a+1);
	  vv(y1,x1)=v(y1*a-a+1,x1*a-a+1);
	end
end


figure(2);
quiver(uu,vv,.8);
axis square;

   
   
