% Optical flow by iteractive method
% 	s=smooth parameter
% 	n=number of iterations
function  OpticalFlow(inputimage1,inputimage2,s,n)

% Load images and display
I1=imread(inputimage1,'bmp');
I2=imread(inputimage2,'bmp');

% Convert to greylevel
if(ndims(I1)==3)
    I1=rgb2gray(I1); end

if(ndims(I2)==3)
    I2=rgb2gray(I2); end

%	Display
%figure(1)
%subplot(1,2,1); imshow(I1);
%subplot(1,2,2); imshow(I2);

% Convert to Double
I1=double(I1);
I2=double(I2);

% Image size
[rows,columns]=size(I1);  % I2 must have the same size

% Result flow
u=zeros(rows,columns);
v=zeros(rows,columns);

% Temporal flow
tu=zeros(rows,columns);
tv=zeros(rows,columns);

% Flow computation
for k=1:n   % iterations
  for x=2:columns-1
	for y=2:rows-1
	  % derivatives
	  Ex=(I1(y,x+1)-I1(y,x)+I2(y,x+1)-I2(y,x)+I1(y+1,x+1)-I1(y+1,x)+I2(y+1,x+1)-I2(y+1,x))/4;
	 	Ey=(I1(y+1,x)-I1(y,x)+I2(y+1,x)-I2(y,x)+I1(y+1,x+1)-I1(y,x+1)+I2(y+1,x+1)-I2(y,x+1))/4;
	  Et=(I2(y,x)-I1(y,x)+I2(y+1,x)-I1(y+1,x)+I2(y,x+1)-I1(y,x+1)+I2(y+1,x+1)-I1(y+1,x+1))/4;
	  % average
	  AU=(u(y,x-1)+u(y,x+1)+u(y-1,x)+u(y+1,x))/4;
	  AV=(v(y,x-1)+v(y,x+1)+v(y-1,x)+v(y+1,x))/4;
	  % update value
	  A=(Ex*AU+Ey*AV+Et);
	  B=(1+s*(Ex*Ex+Ey*Ey));
	  tu(y,x)=AU-(Ex*s*A/B);
	  tv(y,x)=AV-(Ey*s*A/B);
	end % for (x,y)  			
	end   
	% update
	for x=2:columns-1
	for y=2:rows-1
	    u(y,x)=tu(y,x); v(y,x)=tv(y,x);
	end % for (x,y)  			
	end     
end   % iterations

% display result
%low dimension
a=3;
r=round(rows/a);
c=round(columns/a);
uu=zeros(r,c);
vv=zeros(r,c);
for x1=1:c
	for y1=1:r
	  uu(y1,x1)=u(y1*a-a+1,x1*a-a+1);
	  vv(y1,x1)=v(y1*a-a+1,x1*a-a+1);
	end
end


figure(2);
quiver(uu,vv,1);
axis square;


   
   
