import java.awt.*;
import java.awt.image.*;
import java.awt.Graphics;
import java.io.*;
import javax.swing.*;
import javax.imageio.*;
import java.awt.geom.Rectangle2D;


public class CreateSymmetry extends JApplet{
		int width;
		int height;
		double distanceWeightingMultiplier;
		int totalResultimage[] = new int[64*64];

		public float distanceweight(int Xi, int Xj, int Yi, int Yj, float sigma, float mu){
			return (float)distanceWeightingMultiplier*(float)Math.pow(Math.E,(-((distance(Xi,Xj,Yi,Yj)-mu)/(2*sigma))));
		}
		public float distance(int Xi, int Xj, int Yi, int Yj){
			return (float)Math.sqrt((Xi-Yi)*(Xi-Yi)+(Xj-Yj)*(Xj-Yj));
		}
		public float phaseweight(int Xi, int Xj, int Yi, int Yj, double[] direction){
			return (float)(1-Math.cos(direction[Xj*width+Xi]+direction[Yj*width+Yi]-2*Math.atan(Yi-Yj/Xi-Xj)))*(1-(float)Math.cos(direction[Xj*width+Xi]-direction[Yj*width+Yi]));
		}
		public int midpoint(int x1, int x2){
			return (int)((x1+x2)/2);
		}
		public int[] symmetry_map(double[] input, double[] direction, float sigma, float mu, double[] magnitude){
			int[] output = new int[width*height];
			double max=0;
			float dist, phase;
			double value;
			distanceWeightingMultiplier=1/Math.sqrt(2*Math.PI*sigma);
		
			for (int Xi=1;Xi<width-1;Xi++) {
	//			System.out.println(100*Xi/width+"%");
				for (int Xj=1;Xj<height-1;Xj++) {
	//			System.out.print("    "+input[Xj*width+Xi]);
				
					if(input[Xj*width+Xi]==0)
						continue;
		
					for (int Yi=1;Yi<width-1;Yi++) {
						for (int Yj=1;Yj<height-1;Yj++) {

							if(input[Yj*width+Yi]==0 || (Xi==Yi && Xj==Yj))
								continue;

							dist=distanceweight(Xi,Xj,Yi,Yj,sigma,mu);
							phase=phaseweight(Xi,Xj,Yi,Yj,direction);
							value=dist*phase*input[Xj*width+Xi]*input[Yj*width+Yi];
							magnitude[midpoint(Xj,Yj)*width+midpoint(Xi,Yi)] += (value);
						}
					}

				}
			}
			for (int Xi=1;Xi<width-1;Xi++) {
				for (int Xj=1;Xj<height-1;Xj++) {
					if(max<magnitude[Xj*width+Xi])
						max=magnitude[Xj*width+Xi];
				}
			}		

			// normalising ratio
			float ratio = 255 / (float)max;
		
			// normalise values
			for (int x=1;x<width-1;x++) {
				for (int y=1;y<height-1;y++) {
					magnitude[y*width+x] = (int)(magnitude[y*width+x] * ratio);
					int M = (int)magnitude[y*width+x];
					output[y*width+x] = 0xff000000 | (M << 16 | M << 8 | M);
				}
			}
		
			return output;

		}	
		// Sobel edge detection
		public int[] SobelEdge(int[] input, double[] magnitude, double[] direction) {
	
			int[] output = new int[width*height];
			double max=0;
		
			for (int x=1;x<width-1;x++) {
				for (int y=1;y<height-1;y++) {
				
					// apply the sobel templates in x and y
					int Mx = SobelX(input, x, y);
					int My = SobelY(input, x, y);
				
					// calculate edge magnitude
					double M = Math.sqrt((Mx*Mx) + (My*My));
					magnitude[y*width+x] = M;
				
					// find max value for normalising
					if (M > max) max = M;
				
					// store the direction of the edge
					direction[y*width+x] = Math.atan2(Mx,My);
				}
			}
		
			// normalising ratio
			float ratio = 255 / (float)max;
		
			// normalise values to prevent overflows
			for (int x=1;x<width-1;x++) {
				for (int y=1;y<height-1;y++) {
					magnitude[y*width+x] = (magnitude[y*width+x] * ratio);
					int M = (int)magnitude[y*width+x];
	//				output[y*width+x] = (int)direction[y*width+x];
					output[y*width+x] = 0xff000000 | (M << 16 | M << 8 | M);
				}
			}
		
			return output;
		}
	
		public int SobelX(int[] image, int x, int y) {
	
			int M = 0;
		
			for (int y1=y-1;y1<=y+1;y1++) {
				M += (image[y1*width+(x-1)] & 0xff) - (image[y1*width+(x+1)] & 0xff);
				if (y1 == y) M += (image[y1*width+(x-1)] & 0xff) - (image[y1*width+(x+1)] & 0xff);
			}

			return M;
		}
	
		public int SobelY(int[] image, int x, int y) {
	
			int M = 0;
		
			for (int x1=x-1;x1<=x+1;x1++) {
				M += (image[(y-1)*width+x1] & 0xff) - (image[(y+1)*width+x1] & 0xff);
				if (x1 == x) M += (image[(y-1)*width+x1] & 0xff) - (image[(y+1)*width+x1] & 0xff);
			}

			return M;
		}
		public static String replace(String source, String pattern, String replace)
	    {
	        if (source!=null)
	        {
		        final int len = pattern.length();
		        StringBuffer sb = new StringBuffer();
		        int found = -1;
		        int start = 0;

		        while( (found = source.indexOf(pattern, start) ) != -1) {
		            sb.append(source.substring(start, found));
		            sb.append(replace);
		            start = found + len;
		        }

		        sb.append(source.substring(start));

		        return sb.toString();
	        }
	        else return "";
	    }

	
		public CreateSymmetry(String pathname){


			File theFile = new File(pathname);
			File[] theFiles;

		    // Create a directory; all ancestor directories must exist
		    boolean success = (new File(pathname+"_symmetry")).mkdir();
		    if (!success) {
				System.out.println("Symmetry Directory Could Not Be Created");
		    }

			if (theFile.isDirectory()){

			 	theFiles=theFile.listFiles();

				for (int files=0; files<theFiles.length; files++){
					try{
						String filename=theFiles[files].getName();

						if(!filename.endsWith("png"))
								continue;

						Image image = ImageIO.read(theFiles[files]);

						width = image.getWidth(this);
						height = image.getHeight(this);
						System.out.println("Processing symmetry for: "+ filename +" width="+width+" height"+height);

						int[] orig = new int[width*height];
						double magnitude[] = new double[width*height];
						double direction[] = new double[width*height];
						int magint[] = new int[width*height];
						double magnitude2[] = new double[width*height];
						int fin[] = new int[width*height];


						//copy pixel values into orig
						PixelGrabber grabber = new PixelGrabber(image, 0, 0, width, height, orig, 0, width);
						try {
							grabber.grabPixels();
						}
						catch(InterruptedException e) {
							System.out.println("error: " + e);
						}

						magint = SobelEdge(orig, magnitude, direction);
						Image edgeImage;
						edgeImage = createImage(new MemoryImageSource(width, height, magint, 0, width));

						float sigma=10f;
						float mu=90f;

						fin = symmetry_map(magnitude,direction,sigma,mu,magnitude2);

						Image finImage;
						finImage = createImage(new MemoryImageSource(width, height, fin, 0, width));

						for (int x=1;x<width-1;x++) {
							for (int y=1;y<height-1;y++) {
								totalResultimage[y*width+x]+=magnitude2[y*width+x];
							}
						}

						String outFilename=(filename.substring(0,filename.length()-4));
						outFilename = replace(outFilename, "_scaled", "");
						outFilename=outFilename.concat("_symmetry.png");
						
						BufferedImage imageb = new BufferedImage(width, height, BufferedImage.TYPE_INT_ARGB);
						Graphics2D bufImageGraphics = imageb.createGraphics();
				  		bufImageGraphics.drawImage(finImage, 0, 0, null);

						ImageIO.write(imageb, "png", new File(pathname+"_symmetry",outFilename));

					}
					catch(IOException ioe){ioe.printStackTrace();}
				}//end for

				int max=0;
				for (int x=1;x<width-1;x++) {
					for (int y=1;y<height-1;y++) {
						if(max<totalResultimage[y*width+x])
							max=totalResultimage[y*width+x];
					}
				}
				float ratio = 255 / (float)max;
	
				// normalise values to prevent overflows
				for (int x=1;x<width-1;x++) {
					for (int y=1;y<height-1;y++) {
						totalResultimage[y*width+x] = (int)(totalResultimage[y*width+x] * ratio);
						int M = (int)totalResultimage[y*width+x];
						totalResultimage[y*width+x] = 0xff000000 | (M << 16 | M << 8 | M);
					}
				}

				Image finImage = createImage(new MemoryImageSource(width, height, totalResultimage, 0, width));

				BufferedImage imageb = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
				Graphics2D bufImageGraphics = imageb.createGraphics();
		  		bufImageGraphics.drawImage(finImage, 0, 0, null);

				try{
					ImageIO.write(imageb, "png", new File(pathname+"_symmetry",pathname+".png"));
					ImageIO.write(imageb, "png", new File(pathname+".png"));
					ImageIO.write(imageb, "jpg", new File(pathname+"_symmetry","folder.jpg"));
				}
				catch(IOException ioe){ioe.printStackTrace();}
				
				System.out.println("Output File: "+ pathname+"_symmetry/"+pathname+".png");

			}//end if dir
		}//end constructor
	

public static void main(String[] argv){
	CreateSymmetry b;
    for (int i = 0; i < argv.length; i++)
		b = new CreateSymmetry(argv[i]);

//	         GetUSCapital MyCa=new GetUSCapital();
}
}

