// STL compliant include
#ifndef INCLUDE_SourceLine
#define INCLUDE_SourceLine

class SourceLine{
    public:

		// the global line number for GLE
		// every line of gle source needs its own
		// unique line number thus included files
		// must have this set
		int
			line_no;  

		// the real line number when referencing the source file
		int 
			source_line_no;

		string
			filename,
			text;

       SourceLine();
	   SourceLine(const SourceLine& cl);
       ~SourceLine();
       SourceLine& operator = (const SourceLine& gr);
       void showPosPointer(int pos, ostream& out);
};
int operator==(const SourceLine& a , const SourceLine& b);
inline void copy( SourceLine& a , const SourceLine& b){
    a = b;
}
ostream& operator<<(ostream& out, SourceLine d);

typedef std::list<SourceLine>					_GLESource;
typedef std::list<SourceLine>::iterator			_itGLESource;
typedef std::list<SourceLine>::const_iterator	_citGLESource;

#endif

