class axis_struct {
public:
	int type;	/* 1=xaxis 2=yaxis 3=x2axis 4=y2axis */
	double base;
	double length;
	double shift;
	int color;
	int label_font;
	double label_hei;
	double label_scale;
	double label_dist;
	int log,lg1,lg25,lgset;	/* 0=normal 1=log, lg*=small labelling values */
	double min,max;
	int minset,maxset;
	int nofirst,nolast;
	int nticks,nsubticks;
	double dticks,dsubticks;
	double ticks_length,ticks_scale,ticks_lwidth;
	char ticks_lstyle[9];
	double subticks_length,subticks_scale,subticks_lwidth;
	char subticks_lstyle[9],label_lstyle[9];
	int off;
	int label_off;
	int side_off,ticks_off,subticks_off;
	double side_lwidth,label_lwidth;
	char side_lstyle[9];
	int title_font;
	int ticks_color,side_color,subticks_color,label_color;
	double title_dist;
	double title_hei,title_scale;
	int title_rot,title_off;
	int title_color;	/* 0=normal, 1=rotate 180 */
	string title;
	vector<string> names;
	vector<double> places;
	int negate;
	string format;
public:
	axis_struct();
	~axis_struct();
	void init(int i);
	string* getNamePtr(int i);	
	void setName(int i, const char* name);
	void setPlace(int i, double place);
	inline void addName(const char* name) { names.push_back(string(name)); }
	inline void addPlace(double place) { places.push_back(place); }
	inline int getNbPlaces() { return places.size(); }
	inline int getNbNames() { return names.size(); }
};

void draw_axis(axis_struct *ax);	/* Draws the axis */

void print_axis(axis_struct *ax);
