#include <string>
#include <vector>
#include <list>
#include <map>
using namespace std;
#include "SourceLine.h"

#include "all.h"
#include "tokens/Tokenizer.h"
#include "mygraph.h"
#include "justify.h"
#include "core.h"
#include "gprint.h"
#include "mem_limits.h"
#include "token.h"

#define BEGINDEF extern
#include "begin.h"

#define true (!false)
#define false 0
#define dbg if ((gle_debug & 32)>0)

extern int gle_debug;

extern int *(*gpcode)[];   /* gpcode is a polonger to an array of poiter to int */
extern int (*gplen)[];   /* gpcode is a pointer to an array of int */
extern int ngpcode;

static double base_owidth;
void g_textfindend(char *s, double *x, double *y);
void tab_line(char *ss,char *outbuff);

void begin_tab(int *pln, int *pcode, int *cp) {
	int cjust,len;
	char *tabbuff;
 	char tbuff[200];
 	double zzz;
	int save_fnt;
	double save_hei;
	g_get_font(&save_fnt);
	g_get_hei(&save_hei);
	tabbuff = (char*) myalloc(5000);
	g_get_just(&cjust);
	g_textfindend("o",&base_owidth,&zzz);
	tabbuff[0] = 0;
	(*pln)++;
	while (begin_line(pln, tbuff, &len)) {
		tab_line(tbuff,tabbuff);
	}
	dbg printf("+_+_+_+_+_ %d {%s} \n",strlen(tabbuff),tabbuff);
	g_set_font(save_fnt);
	g_set_hei(save_hei);
	text_block(UC tabbuff,0.0,cjust);
	myfree(tabbuff);
}

#define aspace(c) (c == ' ')
void tab_line(char *ss, char *tabbuff) {
	double bl,br,bu,bd,swid;
	char wbuff[100],str2[30];
	char *s,*wb;
	int i,c=0,cjust,savec,old_len;
	swid = base_owidth;
	old_len = strlen(tabbuff);
	for (s=ss;*s!=0;) {
		if (*s==9) {
			c = (c/8)*8+8; s++;
		} else {
		  if (aspace(*s))  {
			c++; s++;
		  } else {
			wb = wbuff;
			savec = c;
			for (;*s!=0  && !(*s==9)
				&& !(isspace(*s) && isspace(*(s+1))) ;) {
				if (*s == '\\') if (*(s+1) != '\\') c -= 2;
				if (strchr("{}_^",*s)!=NULL) {
					*wb++ = '\\';
				}
				*wb++ = *s++; c++;
			}
			*wb++ = 0;
			g_textfindend(wbuff,&br,&bd);
			wb--;
			sprintf(wb,"\\movexy{%g}{0}",-br-swid*savec);
			sprintf(str2,"\\movexy{%g}{0}",swid*savec);
			if (strlen(tabbuff)>3000) {
				gprint("Too much tabbing text in one section.\n");
				return;
			}
			strcat(tabbuff,str2);
			strcat(tabbuff,wbuff);
		  }
		}
	}
	if (strlen(tabbuff)==old_len)  strcat(tabbuff,"\\movexy{0}{0}");
	strcat(tabbuff,"\n");
}
