
#define BEGINDEF

#include <math.h>
#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string>
#include <vector>
#include <list>
#include <map>
using namespace std;
#include "SourceLine.h"
#include "all.h"
#include "mem_limits.h"
#include "tokens/Tokenizer.h"
#include "glearray.h"
#include "token.h"
#include "begin.h"
#include "gprint.h"
#include "cutils.h"
#include "polish.h"

void replace_exp(char* exp);

int begin_token(int **pcode,int *cp,int *pln,char *srclin,TOKENS tk,int *ntk,char *outbuff) {
	g_set_error_line(*pln);
	(*pcode) = (*gpcode)[(*pln)++];
	if ((*pcode)[1] != 5 || (*pcode)[2] == 0) {
		(*pln)--;
		return false;
	}
	strcpy(srclin,(char *) ((*pcode)+3));	
	replace_exp(srclin);
	for (int i = 0; i < TOKEN_LENGTH; i++) {
		strcpy(tk[i], " ");
	}	
	token(srclin,tk,ntk,outbuff);
	return true;
}

bool begin_line(int *pln, char *srclin, int *len) {
	int *pcode = (*gpcode)[(*pln)++];
	if (pcode[1] != 5 || pcode[2] == 0) {
		(*pln)--;
		return false;
	}
	char* src = (char *)(pcode+3);
	strcpy(srclin, src);
	replace_exp(srclin);
	(*len) = strlen(src);
	return true;
}

void begin_init() {
	strcpy(space_str," \0");
	for (int i = 0; i < TOKEN_LENGTH; i++) {
		strcpy(tk[i], " ");
	}	
}

int begin_next_line(int *pcode, int *cp) {
	return true;
}

// replaces \expr{some_exp} by the result of evaluating some_exp
void replace_exp(char* exp) {
	char *ptr = str_i_str(exp, "\\EXPR{");
	while (ptr != NULL) {
		int depth = 0;
		int first = ptr-exp;
		int pos = first+6; // 6 = strlen("\\EXPR{")
		char ch = exp[pos];
		string to_eval = "", eval_res;
		while (ch != 0 && (ch != '}' || depth > 0)) {
			if (ch == '{') depth++;
			else if (ch == '}') depth--;
			if (ch != 0 && (ch != '}' || depth > 0)) {
				to_eval += ch;
				ch = exp[++pos];
			}
		}
		polish_eval_string(to_eval.c_str(), &eval_res, true);
		string at_end = exp+pos+1;
		exp[first] = 0;
		strcat(exp, eval_res.c_str());
		strcat(exp, at_end.c_str());
		ptr = str_i_str(exp, "\\EXPR{");
	}
}

