/*--------------------------------------------------------------*/
/*        CORE, for GLE V3.0                                         */
/*--------------------------------------------------------------*/

/* g_scr_* needs to be added */
/* g_int_* needs to be decided/added */
/* g_tex_* needs to be decided/added */

/*---------------------------------------------------------------------------*/
#include <math.h>
#include <string>
#include <vector>
#include <sstream>
#include <list>
#include <map>
using namespace std;

#include "bitmap/img2ps.h"
#include "SourceLine.h"
#include "all.h"
#include "tokens/Tokenizer.h"
#include "mygraph.h"
#include "core.h"
#include "d_interface.h"
#include "justify.h"
#include "gprint.h"
#include "var.h"
#include "sub.h"
#include "file_io.h"
#include "cutils.h"
#include "run.h"

int mystrncmp(char *a, char *b, int n);
gmodel g;
double tmpimg[3][3];
double tmpimg2[3][3];
double font_lwidth;

static int ngsave;
static char *gsave[100];

/*---------------------------------------------------------------------------*/

//#define true (!false)
//#define false 0
#define dbg if ((gle_debug & 32)>0)
extern int gle_debug;
/*---------------------------------------------------------------------------*/
/* The global variables that CORE keeps track of */
/*-----------------------------------------------*/

static int jj;
void test_unit(void);
int gunit=false;
#define color_black 0X01000000
unsigned int coreleft()
{
        return 4000000;
}

unsigned int farcoreleft()
{
        return 1200000;
}
/*---------------------------------------------------------------------------*/
// Called only once g_clear is called for each script.
void g_init() {
	g.devtype = GLE_DEVICE_NONE;
	g.dev = NULL;
	g.console_output = false;
	g.needs_newline = true;
}
/*---------------------------------------------------------------------------*/
void g_select_device(int device) {
	g.devtype = device;
	if (g.dev != NULL) {
		delete g.dev;
		g.dev = NULL;
	}
	switch (device) {
		case GLE_DEVICE_PS:
			g.dev = new PSGLEDevice(false); break;
		case GLE_DEVICE_EPS:
			g.dev = new PSGLEDevice(true); break;
		case GLE_DEVICE_SVG:
			g.dev = new SVGGLEDevice(); break;
		case GLE_DEVICE_DUMMY:
			g.dev = new GLEDummyDevice(false); break;
#ifdef GLEX11
		case GLE_DEVICE_X11:
			g.dev = new X11GLEDevice(); break;
#endif
	}
}
/*---------------------------------------------------------------------------*/
GLEDevice* g_get_device_ptr() {
	return g.dev;
}
/*---------------------------------------------------------------------------*/
int g_get_device() {
	return g.devtype;
}
/*---------------------------------------------------------------------------*/
void g_devcmd(char *s)
{
        g.dev->devcmd(s);
}
/*---------------------------------------------------------------------------*/
void g_resetfont() {
        g.dev->resetfont();
}
/*---------------------------------------------------------------------------*/
void g_dfont(char *s)
{
        g.dev->dfont(s);
}
/*---------------------------------------------------------------------------*/
int g_get_grey(double v)
{
        colortyp c;
        c.b[B_F] = (unsigned)( (char)  1 );
        c.b[B_R] = (unsigned)( (char) 255*v );
        c.b[B_G] = (unsigned)( (char) 255*v );
        c.b[B_B] = (unsigned)( (char) 255*v );
        return c.l;
}
/*---------------------------------------------------------------------------*/
void g_color_set_black(colortyp& color) {
	color.b[B_F] = 1;
	color.b[B_R] = 0;
	color.b[B_G] = 0;
	color.b[B_B] = 0;
}
/*---------------------------------------------------------------------------*/
void g_hint(char *s)
{
        gprint("%s\n",s);
}
/*---------------------------------------------------------------------------*/

void g_message(const char *s)
{
	if (!g.console_output) {
		g.console_output = true;
		if (g.needs_newline) cout << endl;
	}
        printf("%s\n",s);
}
/*---------------------------------------------------------------------------*/
void g_reset_message() {
	if (g.console_output) {
		cout << endl;
	}
	g.console_output = false;
}
/*---------------------------------------------------------------------------*/
void g_message_first_newline(bool newline) {
	g.needs_newline = newline;
}
/*---------------------------------------------------------------------------*/
void g_source(char *s)
{
        g.dev->source(s);
}
/*---------------------------------------------------------------------------*/
void g_get_end(dbl *x,dbl *y)
{
        *x = tex_xend();
        *y = tex_yend();
}
void g_set_end(dbl x,dbl y)
{
        gprint("What is setting end \n");
}
/*---------------------------------------------------------------------------*/
void g_get_usersize(dbl *x,dbl *y) {
        *x = g.userwidth;
        *y = g.userheight;
}
void g_get_pagesize(dbl *x,dbl *y) {
        *x = g.pagewidth;
        *y = g.pageheight;
}
void g_get_pagesize(dbl *x, dbl *y, int *type) {
        *x = g.pagewidth;
        *y = g.pageheight;
	*type = g.papersize;
}
/*---------------------------------------------------------------------------*/
void g_get_bounds(dbl *x1,dbl *y1,dbl *x2,dbl *y2)
{
        *x1 = g.xmin;
        *y1 = g.ymin;
        *x2 = g.xmax;
        *y2 = g.ymax;
}
/*---------------------------------------------------------------------------*/
void g_init_bounds()
{
        g.xmin = 1e30;
        g.ymin = 1e30;
        g.xmax = -1e30;
        g.ymax = -1e30;
}
/*---------------------------------------------------------------------------*/
void g_get_type(char *t)
{
        g.dev->get_type(t);
}
/*---------------------------------------------------------------------------*/
void g_set_path(int onoff)
{
        if (static_cast<bool>(onoff)==g.inpath) return;
        g_flush();
        if (static_cast<bool>(onoff) == true) {
                g.inpath=true;
                g.npath = 0;
                g.xinline=false;
        } else {
                g.inpath = false;
                g.xinline = false;
        }
        g.dev->set_path(onoff);
}
/*---------------------------------------------------------------------------*/
void g_get_path(int *onoff)
{
        *onoff = g.inpath;
}
/*---------------------------------------------------------------------------*/
void g_newpath()
{
        g.npath = 0;
        g.dev->newpath();
}
/*---------------------------------------------------------------------------*/
void g_set_size(double width, double height, bool box) {
        g.userwidth  = width;
        g.userheight = height;
	g.hasbox = box;
}

void g_set_pagesize(double width, double height) {
	g.pagewidth = width;
	g.pageheight = height;
	g.papersize = GLE_PAPER_UNKNOWN;
}

void g_set_margins(double top, double bottom, double left, double right) {
	g.topmargin = top; g.bottommargin = bottom;
	g.leftmargin = left; g.rightmargin = right;
}

int g_papersize_type(const string& papersize) {
	if (papersize == "a0paper") {
		return GLE_PAPER_A0;
	} else if (papersize == "a1paper") {
		return GLE_PAPER_A1;
	} else if (papersize == "a2paper") {
		return GLE_PAPER_A2;
	} else if (papersize == "a3paper") {
		return GLE_PAPER_A3;
	} else if (papersize == "a4paper") {
		return GLE_PAPER_A4;
	} else if (papersize == "letterpaper") {
		return GLE_PAPER_LETTER;
	} else {
		return GLE_PAPER_UNKNOWN;
	}
}

/*
4A0	1682  2378	?	?	?	?
2A0	1189  1682	?	?	?	?
A0	841  1189	B0	1000  1414	C0	917  1297
A1	594  841 	B1	707  1000	C1	648  917
A2	420  594 	B2	500  707 	C2	458  648
A3	297  420 	B3	353  500 	C3	324  458
A4	210  297	B4	250  353	C4	229  324
A5	148  210 	B5	176  250 	C5	162  229
A6	105  148 	B6	125  176 	C6	114  162
A7	74  105 	B7	88  125 	C7	81  114
A8	52  74 	B8	62  88 	C8	57  81
A9	37  52 	B9	44  62 	C9	40  57
A10	26  37 	B10	31  44 	C10	28  40
*/

void g_set_pagesize(int type) {
	g.papersize = type;
	switch (type) {
		case GLE_PAPER_A0:
			g.pagewidth = 84.1;
			g.pageheight = 118.9; break;
		case GLE_PAPER_A1:
			g.pagewidth = 59.4;
			g.pageheight = 84.1; break;
		case GLE_PAPER_A2:
			g.pagewidth = 42.0;
			g.pageheight = 59.4; break;
		case GLE_PAPER_A3:
			g.pagewidth = 29.7;
			g.pageheight = 42.0; break;
		case GLE_PAPER_A4:
			g.pagewidth = 21.0;
			g.pageheight = 29.7; break;
		case GLE_PAPER_LETTER:
			g.pagewidth = 21.6;
			g.pageheight = 27.9; break;
	}
}

void g_set_pagesize(const string& papersize) throw (ParserError) {
	SpaceStringTokenizer tokens(papersize.c_str());
	const string& token = tokens.next_token();
	int type = g_papersize_type(token);
	if (type != GLE_PAPER_UNKNOWN) {
		g_set_pagesize(type);
	} else {
		tokens.pushback_token();
		g.pagewidth = tokens.next_double();
		g.pageheight = tokens.next_double();
		g.papersize = GLE_PAPER_UNKNOWN;
	}
}

void g_set_margins(const string& margins) throw (ParserError) {
	SpaceStringTokenizer tokens(margins.c_str());
	g.topmargin = tokens.next_double();
	g.bottommargin = tokens.next_double();
	g.leftmargin = tokens.next_double();
	g.rightmargin = tokens.next_double();
}

void g_set_fullpage(bool fullpage) {
	g.fullpage = fullpage;
}

bool g_is_fullpage() {
	return g.fullpage;
}

void g_set_landscape(bool landscape) {
	g.landscape = landscape;
}

bool g_is_landscape() {
	return g.landscape;
}

double g_draw_width() {
	if (g_is_landscape()) {
		return g.pageheight - g.leftmargin - g.rightmargin;
	} else {
		return g.pagewidth - g.leftmargin - g.rightmargin;
	}
}

double g_draw_height() {
	if (g_is_landscape()) {
		return g.pagewidth - g.topmargin - g.bottommargin;
	} else {
		return g.pageheight - g.topmargin - g.bottommargin;
	}
}

void g_open(const string& filename) {
	if (g.isopen) return;
	g.isopen = true;
        freeafont();
	g_reset_message();
	bool centerfig = false;
	if (g.userwidth < 0 || g.userheight < 0) {
		// No size command given: full page + all available space
		g.userwidth = g_draw_width();
		g.userheight = g_draw_height();
		g.fullpage = true;
	} else {
		// Center figure if full page mode
		centerfig = true;
		if (g.fullpage && g.userwidth > g.pagewidth) {
			g_set_landscape(true);
		}
	}
	if (g.fullpage) {
        	g.dev->opendev(g.pagewidth, g.pageheight, filename);
		g_on_open();
		if (g_is_landscape()) {
			g_translate(g.pagewidth, 0);
			g_rotate(90.0);
		}
		if (centerfig) {
			double left = g.leftmargin + (g_draw_width() - g.userwidth)/2;
			double bottom = g.bottommargin + (g_draw_height() - g.userheight)/2;
			g_translate(left, bottom);
		} else {
			g_translate(g.leftmargin, g.bottommargin);
		}
	} else {
        	g.dev->opendev(g.userwidth, g.userheight, filename);
		g_on_open();
	}
	if (g.hasbox) {
		g_box_stroke(0.0, 0.0, g.userwidth, g.userheight, false);
	}
}

/*---------------------------------------------------------------------------*/
void g_close()
{
        g.isopen = false;
        g_flush();
        g.dev->closedev();
}
/*---------------------------------------------------------------------------*/
void g_pscomment(char* ss)
{
	if(g.isopen) {
		gprint("Can't call PSCOMMENT before SIZE command.  Ignoring\n");
	} else {
		g.dev->pscomment(ss);
	}
}
/*---------------------------------------------------------------------------*/
void g_psbbtweak(void) {
}
/*---------------------------------------------------------------------------*/
bool g_is_bbtweak() {
	// return g.bbtweak;
	return true;
}
/*---------------------------------------------------------------------------*/
void g_set_line_cap(int i)
{
        /*  lcap, 0= butt, 1=round, 2=projecting square */
        if (i<0 || i>2) {
                gprint("Invalid line cap, {%d}, valid numbers are \n",i);
                gprint("        0= butt, 1=round, 2=projecting square \n");
        }
        g.dev->set_line_cap(i);
        g.lcap = i;
}
/*---------------------------------------------------------------------------*/
void g_set_line_join(int i)
{
        if (i<0 || i>2) {
                gprint("Invalid line join, {%d}, valid numbers are \n",i);
                gprint("        0= mitre, 1=round, 2=bevel \n");
        }
        g.dev->set_line_join(i);
        g.ljoin = i;
}
void g_get_line_join(int *i)
{
        *i = g.ljoin;
}
void g_get_line_cap(int *i)
{
        *i = g.lcap;
}
/*---------------------------------------------------------------------------*/
void g_set_line_miterlimit(double d)
{
        g.dev->set_line_miterlimit(d);
        g.miterlimit = d;
}
/*---------------------------------------------------------------------------*/
void g_get_line_width(double *w)
{
        *w = g.lwidth;
}
/*---------------------------------------------------------------------------*/
void g_set_line_width(double w)
{
        if (w<0) return;
        g.dev->set_line_width(w);
        g.lwidth = w;
}
void g_set_font_width(double w)
{
        font_lwidth = w;
}
/*---------------------------------------------------------------------------*/
void g_get_line_styled(double *w)
{
        *w = g.lstyled;
}
/*---------------------------------------------------------------------------*/
void g_set_line_styled(double w)
{
        if (w==0) return;
        g.dev->set_line_styled(w);
        g.lstyled = w;
}
/*---------------------------------------------------------------------------*/
void g_set_line_style(char *s)
{
        g.dev->set_line_style(s);
        strncpy(g.lstyle,s,8);
}
/*---------------------------------------------------------------------------*/
void g_get_line_style(char *s)
{
        strncpy(s,(char *) &g.lstyle,8);
}
/*---------------------------------------------------------------------------*/
double g_get_angle_deg() {
	if (fabs(g.image[0][0]) <= 1e-6) {
		return g.image[1][0] > 0.0 ? 90.0 : -90.0;
	} else {
		return atan(g.image[1][0]/g.image[0][0])*180.0/GLE_PI;
	}
}
/*---------------------------------------------------------------------------*/
void g_dev(double x, double y,double *xd,double *yd) {
        if (static_cast<bool>(gunit)==true) {
		*xd = x; *yd = y;
	} else {
        	*xd = g.image[0][0]*x + g.image[0][1]*y + g.image[0][2];
        	*yd = g.image[1][0]*x + g.image[1][1]*y + g.image[1][2];
        }
}
/*---------------------------------------------------------------------------*/
void g_undev(double ux,double uy, double *x,double *y)
{
        static double xx,yy,cdiv,xd,yd;
        if (static_cast<bool>(gunit)==true) { *x = ux; *y = uy; }
        else {
        cdiv = ( g.image[0][1]*g.image[1][0] - g.image[0][0]*g.image[1][1] );
        if (cdiv==0) {gprint("Image matrix FLAT, a 1D world, giving up \n");return;}
        xd = ux - g.image[0][2];
        yd = uy - g.image[1][2];
        xx = -xd*g.image[1][1] + yd*g.image[0][1];
        *x = xx/cdiv;
        yy = xd*g.image[1][0]-yd*g.image[0][0];
        *y = yy/cdiv;
        }
}
/*---------------------------------------------------------------------------*/
void g_rundev(double x, double y,double *xd,double *yd)
{
        static double zx,zy;
        g_undev(0,0,&zx,&zy);
        g_undev(x,y,xd,yd);
        *xd -= zx;
        *yd -= zy;
}
void g_rdev(double x, double y,double *xd,double *yd)
{
        static double zx,zy;
        g_dev(0,0,&zx,&zy);
        g_dev(x,y,xd,yd);
        *xd -= zx;
        *yd -= zy;
}
/*---------------------------------------------------------------------------*/
void g_fill()
{
        g.dev->fill();
}
/*---------------------------------------------------------------------------*/
void g_fill_ary(int nwk,double *wkx,double *wky)
{
        g.dev->fill_ary(nwk,wkx,wky);
}
void g_line_ary(int nwk,double *wkx,double *wky)
{
        g.dev->line_ary(nwk,wkx,wky);
}
/*---------------------------------------------------------------------------*/
void g_stroke()
{
        g.dev->stroke();
}
/*---------------------------------------------------------------------------*/
void g_clip()
{
        /* Find the intersection of the current path with the clipping path */
        /* and thus define a new clipping path */
        g.dev->clip();
}
/*---------------------------------------------------------------------------*/
void g_set_matrix(double newmat[3][3])
{
        double x1, y1, x2, y2, x3, y3, x4, y4;
        double a1, b1, a2, b2, a3, b3, a4, b4;

        g_dev(g.xmin,g.ymin,&x1,&y1);
        g_dev(g.xmax,g.ymin,&x2,&y2);
        g_dev(g.xmax,g.ymax,&x3,&y3);
        g_dev(g.xmin,g.ymax,&x4,&y4);

        if (memcmp(newmat,g.image,GLE_TRNS_MATRIX_SIZE) != 0) {
		 g.dev->set_matrix(newmat);
	}
        memcpy(&g.image,newmat,GLE_TRNS_MATRIX_SIZE);

        g_init_bounds();

        if (g.xmin<g.xmax)  {
                g_undev(x1,y1,&a1,&b1);
                g_undev(x2,y2,&a2,&b2);
                g_undev(x3,y3,&a3,&b3);
                g_undev(x4,y4,&a4,&b4);
                g_set_bounds(a1,b1);
                g_set_bounds(a2,b2);
                g_set_bounds(a3,b3);
                g_set_bounds(a4,b4);
        }
}
/*---------------------------------------------------------------------------*/
void mat_mult(double a[3][3],double b[3][3])
{
        static double c[3][3],tot;
        int y,xb,x;
        for (y=0;y<3;y++) {
          for (xb=0;xb<3;xb++) {
                tot = 0;
                for (x=0;x<3;x++) tot += a[x][y] * b[xb][x];
                c[xb][y] = tot;
          }
        }
        memcpy(a,&c,GLE_TRNS_MATRIX_SIZE);        /* maybe sizeof(*a) would be better? */
}
/*---------------------------------------------------------------------------*/
void g_rotate(double ar)
{
        static double r[3][3],unx,uny,cx,cy;
        ar = GLE_PI*ar/180;
        r[0][0] = cos(ar);
        r[0][1] = -sin(ar);
        r[1][0] = sin(ar);
        r[1][1] = cos(ar);
        r[2][2] = 1;
        g_dev(g.curx,g.cury,&cx,&cy);
        g_rundev(-cx,-cy,&unx,&uny);
        g_translate(unx,uny);
        memcpy(tmpimg,g.image,GLE_TRNS_MATRIX_SIZE);
        mat_mult(tmpimg,r);
        g_set_matrix(tmpimg);
        g_rundev(cx,cy,&unx,&uny);
        g_translate(unx,uny);        /* not shore about this ORIGIN stuff */
        test_unit();
}
/*---------------------------------------------------------------------------*/
void gg_unrotate(void);
void gg_rerotate(void);
void g_scale(double sx,double sy)
{
        /* The idea is to rotate or scale about the CURRENT POINT */
        static double r[3][3],unx,uny,cx,cy;
        r[0][0] = sx;
        r[1][1] = sy;
        r[2][2] = 1;

        gg_unrotate();
        g_dev(g.curx,g.cury,&cx,&cy);
        g_rundev(-cx,-cy,&unx,&uny);
        g_translate(unx,uny);
        memcpy(tmpimg,g.image,GLE_TRNS_MATRIX_SIZE);
        mat_mult(tmpimg,r);
        g_set_matrix(tmpimg);
        g_rundev(cx,cy,&unx,&uny);
        g_translate(unx,uny);        /* not shore about this ORIGIN stuff */
        gg_rerotate();
        test_unit();
}
void g_shear(double sx,double sy)
{
        /* The idea is to rotate or scale about the CURRENT POINT */
        static double r[3][3],unx,uny,cx,cy;
        r[0][0] = 1;
        r[1][0] = sy;
        r[1][1] = 1;
        r[0][1] = sx;
        r[2][2] = 1;

        gg_unrotate();
        g_dev(g.curx,g.cury,&cx,&cy);
        g_rundev(-cx,-cy,&unx,&uny);
        g_translate(unx,uny);
        memcpy(tmpimg,g.image,GLE_TRNS_MATRIX_SIZE);
        mat_mult(tmpimg,r);
        g_set_matrix(tmpimg);
        g_rundev(cx,cy,&unx,&uny);
        g_translate(unx,uny);        /* not shore about this ORIGIN stuff */
        gg_rerotate();
        test_unit();
}
static double ggra;
void gg_rerotate()
{
        g_rotate(ggra);
}
void gg_unrotate()
{
        double ox,oy,x1,y0,dx,dy,tt;
        g_dev(0.0,0.0,&ox,&oy);
        g_dev(1.0,0.0,&x1,&y0);
        dx = x1-ox;
        dy = y0-oy;
        tt = myatan2(dy,dx);
        ggra = tt * 180.0 / GLE_PI;
        g_rotate(-ggra);
}

/*---------------------------------------------------------------------------*/
void dis_mat(char *s,double m[3][3])
{
        int i,j;
        gprint("\n Matrix {%s} \n",s);
        for (i=0;i<3;i++)
                gprint("        %f %f %f \n",m[0][i],m[1][i],m[2][i]);

}
/*---------------------------------------------------------------------------*/
void g_translate(double ztx,double zty)
{
        static double tx,ty,r[3][3];
        g_rdev(ztx,zty,&tx,&ty);

        r[0][0] = 1;
        r[1][1] = 1;
        r[2][2] = 1;
        r[0][2] = tx;
        r[1][2] = ty;
        memcpy(tmpimg,g.image,GLE_TRNS_MATRIX_SIZE);
        mat_mult(tmpimg,r);
        g_set_matrix(tmpimg);
        test_unit();
}
/*---------------------------------------------------------------------------*/
void g_move(double zx,double zy)
{
        double x,y;
        if (static_cast<bool>(g.xinline)==true) g_flush();
        g.dev->move(zx,zy);
        g.curx = zx;
        g.cury = zy;
        g.closex = zx;
        g.closey = zy;
}
/*---------------------------------------------------------------------------*/
void g_set_pos(double zx,double zy) {
        g.curx = zx;
        g.cury = zy;
        g_set_bounds(zx,zy);
}
/*---------------------------------------------------------------------------*/
void g_rmove(double zx,double zy)
{
        g_move(g.curx+zx,g.cury+zy);
}
/*---------------------------------------------------------------------------*/
void g_rline(double zx,double zy)
{
        g_line(g.curx+zx,g.cury+zy);
}
/*---------------------------------------------------------------------------*/
void g_reverse()         /* reverse the order of stuff in the current path */
{        g.dev->reverse();        }
/*---------------------------------------------------------------------------*/
void g_closepath()
{
        if (g.inpath) g.dev->closepath();
        else g_line(g.closex,g.closey);
        g.curx = g.closex;
        g.cury = g.closey;
        if (!g.inpath) g_flush();
}
/*---------------------------------------------------------------------------*/
void g_line(double zx,double zy)
{
        double x,y;
        g.dev->line(zx,zy);
        if (g.xinline==false) {
                g.xinline = true;
                g_set_bounds(g.curx,g.cury);
        }
        g.curx = zx;
        g.cury = zy;
        g_set_bounds(zx,zy);
}
/*---------------------------------------------------------------------------*/
void g_set_bounds(double x,double y)
{
        if (x<g.xmin) g.xmin = x;
        if (x>g.xmax) g.xmax = x;
        if (y<g.ymin) g.ymin = y;
        if (y>g.ymax) g.ymax = y;
}
/*---------------------------------------------------------------------------*/
void g_get_bounds_box(gbox* box) {
	box->xmin = g.xmin;
	box->xmax = g.xmax;
	box->ymin = g.ymin;
	box->ymax = g.ymax;
}
/*---------------------------------------------------------------------------*/
void g_restore_bounds(gbox* box) {
	g.xmin = box->xmin;
	g.xmax = box->xmax;
	g.ymin = box->ymin;
	g.ymax = box->ymax;
}
/*---------------------------------------------------------------------------*/
void test_unit()
{
        int i,j;
        gunit = true;
        for (i=0;i<3;i++) for (j=0;j<3;j++) if (i!=j) if(g.image[i][j]!=0.0) gunit = false;
        for (i=0;i<3;i++) if (g.image[i][i]!=1.0) gunit = false;
}
/*
        for (i=0;i<3;i++) {
                gprint("Matrix %g %g %g \n",g.image[i][0]
                        ,g.image[i][1],g.image[i][2]);
        }
*/
void tex_clear(void);
/*---------------------------------------------------------------------------*/
void g_clear() {
	/* Reset all params */
	// cout << "calling g_clear()" << endl;
	ngsave = 0;
	g.fontn = 0.0;
	g.fontsz = 0.0;                   /* up to here for font caching */
	g_color_set_black(g.color);
	g_color_set_black(g.fill);
	g.lwidth = 0.0;
	g.lstyled = 0.0;
	g.curx = 0.0;
	g.cury = 0.0;
	g.endx = 0.0;
	g.endy = 0.0;
	g.miterlimit = 0.0;
	g.lcap = 0;
	g.ljoin = 0;
	g.just = 0;
	g.xinline = 0;
	g.npath = 0;                     /* up to here for STATE */
	g.inpath = 0;
	g.xmin = 0.0;
	g.xmax = 0.0;
	g.ymin = 0.0;
	g.ymax = 0.0;                    /* bounds in USER coordinates */
	g.startx = 0.0;
	g.starty = 0.0;
	g.closex = 0.0;
	g.closey = 0.0;	                /* for closepath */
	g.arrowsize = 0.0;
	g.arrowangle = 0.0;
	g.pdfimgformat = PDF_IMG_COMPR_ZIP;
	g.userheight = -1.0;
	g.userwidth = -1.0;
	g.pagewidth = -1.0;
	g.pageheight = -1.0;
	g.papersize = GLE_PAPER_UNKNOWN;
	g.topmargin = 0.0; g.bottommargin = 0.0;
	g.leftmargin = 0.0; g.rightmargin = 0.0;
	g.fullpage = false;
	g.landscape = false;
	g.hasbox = false;
	g.isopen = false;
	/* Reset line style */
	for (int i = 0; i < sizeof(g.lstyle); i++) {
		g.lstyle[i] = 0;
	}
	/* Clear transformation matrix */
        for (int i = 0; i < 3; i++) {
		for (int j = 0; j < 3; j++) {
			g.image[i][j] = 0.0;
		}
		g.image[i][i] = 1.0;
	}
}

void g_on_open() {
	/* Clear device dependent stuff */
        g.dev->clear();
        tex_clear();
        g_set_just(JUST_LEFT);
        g_set_line_styled(.04);
        g_set_line_style("1");
        g_set_line_width(0);
        g_set_color(color_black);
        g_set_fill(color_black);
        g_set_font(1);           /*        Load and set default font         */
        g_set_font_width(-1);    /*        Load and set default font         */
        g_set_hei(1.0);          /*        And set to 1 cm size              */
        g_move(0.0,0.0);
        test_unit();
}

/*---------------------------------------------------------------------------*/
void g_get_xy(double *x,double *y) {
        *x = g.curx;
        *y = g.cury;
}
void g_set_xy(double x, double y) {
	g_move(x,y);
}
/*---------------------------------------------------------------------------*/
void g_flush() {
        g.dev->flush();
        g.xinline = false;
}
/*---------------------------------------------------------------------------*/
void g_arcto(dbl x1,dbl y1,dbl x2,dbl y2,dbl rrr) {
        g.dev->arcto(x1,y1,x2,y2,rrr);
        g.curx = x2;
        g.cury = y2;
        g.xinline = true;
        /* should do MASSES of calc to find bounds of arc  */
        g_set_bounds(x1,y1);
        g_set_bounds(x2,y2);
}
/*---------------------------------------------------------------------------*/
void g_dojust(dbl *x1, dbl *y1, dbl *x2, dbl *y2, int jj) {
        static int jx,jy;
        static double w,y,d;
        jx = (jj & 0xf0) / 16;
        jy = jj & 0x0f;
        d = jx * (*x2-*x1)/2;
        *x1 -= d;
        *x2 -= d;
        d = jy * (*y2-*y1)/2;
        *y1 -= d;
        *y2 -= d;
}
void g_dotjust(dbl *x1, dbl *y1, dbl l, dbl r, dbl u, dbl d, int jj) {
        static int jx,jy,t;
        static double ddd;
        jx = (jj & 0xf0) / 16;
        jy = jj & 0x0f;
        t = (jj & 0xf00) / 256 ;
        ddd = jx * (-l+r)/2;
        *x1 = *x1 + -l - ddd;
        ddd = jy * (u-d)/2;
        if (t==0) *y1 = *y1 - d - ddd;
}
void g_box_stroke(dbl x1, dbl y1, dbl x2, dbl y2, bool reverse) {
        double x,y;
        g_get_xy(&x,&y);
        g.dev->box_stroke(x1,y1,x2,y2,reverse);
        g_set_bounds(x1,y1);
        g_set_bounds(x2,y2);
        g_move(x,y);
}
/*---------------------------------------------------------------------------*/
void g_box_fill(dbl x1, dbl y1, dbl x2, dbl y2) {
        double x,y;
        g_get_xy(&x,&y);
        g.dev->box_fill(x1,y1,x2,y2);
        g_set_bounds(x1,y1);
        g_set_bounds(x2,y2);
        g_move(x,y);
}
/*---------------------------------------------------------------------------*/
enum arrow_direction{CW,CCW};

/*---------------------------------------------------------------------------*/

void g_circle_stroke(dbl zr)
{
        g.dev->circle_stroke(zr);
        g_set_bounds(g.curx-zr,g.cury-zr);
        g_set_bounds(g.curx+zr,g.cury+zr);
}
void g_circle_fill(dbl zr)
{
        g.dev->circle_fill(zr);
        g_set_bounds(g.curx-zr,g.cury-zr);
        g_set_bounds(g.curx+zr,g.cury+zr);
}
void get_circular_arrow_pos(dbl x,dbl y,dbl theta,dbl r,dbl arrowlen,dbl* x1, dbl* y1,dbl* x2,dbl* y2, enum arrow_direction dir)
{
	/*
	x,y .......... coordinates of center of circle
	theta ........ angle were to put arrow should be end or begining must be between 0 and 360
	r     ........ radius of circle
	arrwolen ..... lenght or arrow
	x1,y1 ........ computed starting position of arrow
	x2,y2 ........ computed ending position of arrow
	dir .......... the direction of the arrow CW or CCW
	*/
	dbl dx,dy,tol=0.01;
	*x1 = x + r * cos(GLE_PI*theta/180);
	*y1 = y + r * sin(GLE_PI*theta/180);
	/* ignore sign since it depends upon direction */
	dx = fabs(arrowlen * sin(GLE_PI*theta/180));
	dy = fabs(arrowlen * cos(GLE_PI*theta/180));
	/* adjust sign */
	if(theta >= 0 && theta <= 90)
	{	/* quad 1 */
		if(dir==CW){dx*=-1;}else if(dir==CCW){dy*=-1;}
	}
	else if(theta > 90 && theta <= 180)
	{	/* quad 2 */
		if(dir==CW){dx*=-1;dy*=-1;}
	}
	else if(theta > 180 && theta <= 270)
	{	/* quad 3 */
		if(dir==CW){dy*=-1;}else if(dir==CCW){dx*=-1;}
	}
	else if(theta > 270 && theta <= 360)
	{	/* quad 4 */
		if(dir==CCW){dy*=-1;dx*=-1;}
	}
	*x2 = *x1 + dx;
	*y2 = *y1 + dy;
}

void g_g_arc(dbl r,dbl t1,dbl t2,dbl cx,dbl cy, int marrow,int can_fillpath, int dir)
{
	/* if dir == 0 the arc if dir == 1 then narc */
	double x,y,x1,y1,x2,y2,length;
	enum arrow_direction adir_start,adir_end;
	if(dir==0)
	{	/* arc */
		adir_start=CCW;
		adir_end=CW;
	}
	else
	{	/*narc*/
		adir_start=CW;
		adir_end=CCW;
	}
	/* if arrow is specified */
	/* get current hei and assume that the line
	length is half of that */
	g_get_hei(&length);
	length = length/2;
	g_get_xy(&x,&y);
	if ( marrow == 1 || marrow == 3 )
	{
		/* arrow -- start or both */
		get_circular_arrow_pos(x,y,t1,r,length,&x1,&y1,&x2,&y2,adir_start);
		if (!can_fillpath)
			g_arrow(x2-x1,y2-y1);
		else
			g_psarrow(x1,y1,x2,y2,2);
	}
	if(dir == 0) g.dev->arc(r,t1,t2,cx,cy);
	if(dir == 1) g.dev->narc(r,t1,t2,cx,cy);
	if( marrow == 2 || marrow == 3 )
	{
		/* arrow -- end or both */
		get_circular_arrow_pos(x,y,t2,r,length,&x1,&y1,&x2,&y2,adir_end);
		if (!can_fillpath)
			g_arrow(x2-x1,y2-y1);
		else
			g_psarrow(x1,y1,x2,y2,2);
	}
	g.xinline = true;
	if ((cx!=g.curx) || (cy!=g.cury))
	{
		g.curx = cx;/* + r*cos(PI*t2/180);*/
        g.cury = cy;/* + r*sin(PI*t2/180);*/
    }
}

void g_narc(dbl r,dbl t1,dbl t2,dbl cx,dbl cy, int marrow,int can_fillpath)
{
	return g_g_arc( r, t1, t2, cx, cy, marrow, can_fillpath, 1);
}

void g_arc(dbl r,dbl t1,dbl t2,dbl cx,dbl cy, int marrow,int can_fillpath)
{
	return g_g_arc( r, t1, t2, cx, cy, marrow, can_fillpath, 0);
}


void g_ellipse_stroke(dbl rx, dbl ry)
{
        g.dev->ellipse_stroke(rx,ry);
        g_set_bounds(g.curx-rx,g.cury-ry);
        g_set_bounds(g.curx+rx,g.cury+ry);
}
void g_ellipse_fill(dbl rx, dbl ry)
{
        g.dev->ellipse_fill(rx,ry);
		g_set_bounds(g.curx-rx,g.cury-ry);
        g_set_bounds(g.curx+rx,g.cury+ry);
}

double ellipse_slope(double x, double y, double rx, double ry)
{
	/*
	computes the slope of an ellipse
	ellipse is centered at (0,0) and x and y are coordinates on the ellipse
	rx,ry..... x and y radius of the ellipse
	*/
	double ret=0.0;
	double tol=0.01;
	if(rx == 0.0) return ret; /* error divide by zero */
	if( fabs(1 - fabs(x)/rx)     <= tol)
	{
		/* infinite slope */
		ret = 1e100;
	}
	else if(fabs(1 - fabs(y)/ry) <= tol)
	{
		/* zero slope */
		ret = 0.0;
	}
	else
	{
		/* ok to compute slope --> get absolute value */
		ret = fabs(-(ry*x)/(rx*rx)/sqrt(1-(x*x)/(rx*rx)));
		/* sign of slope depends upon quadrant */
		/* quad 1 negative slope */
		if( x > 0.0 && y > 0.0) ret *= -1.0;
		/* quad 2 positive slope */
		if( x < 0.0 && y > 0.0) ret *=  1.0;
		/* quad 3 negative slope */
		if( x < 0.0 && y < 0.0) ret *= -1.0;
		/* quad 4 positive slope */
		if( x > 0.0 && y < 0.0) ret *=  1.0;
	}
	return ret;
}

void get_elliptical_arrow_pos(dbl x,dbl y,dbl theta,dbl rx,dbl ry,dbl arrowlen,dbl* x1, dbl* y1,dbl* x2,dbl* y2, enum arrow_direction dir)
{
	/*
	x,y .......... coordinates of center of ellipse
	theta ........ angle were to put arrow should be end or begining must be between 0 and 360
	rx ry ........ x and y radius of ellipse
	arrwolen ..... lenght or arrow
	x1,y1 ........ computed starting position of arrow
	x2,y2 ........ computed ending position of arrow
	dir .......... the direction of the arrow CW or CCW
	*/
	double dx,dy,slope;
	double tol=0.02,theta_tol=1;
	/* must be below 360 */
	while (theta>360){theta-=360;}
	/* must be above 0 */
	while (theta<0){theta+=360;}

	*x1 = x + rx * cos(GLE_PI*theta/180);
	*y1 = y + ry * sin(GLE_PI*theta/180);

	slope = ellipse_slope(*x1-x,*y1-y,rx,ry);

	if(slope == 0.0)
	{	/* zero slope */
		dx = arrowlen;
		dy = 0.0;
		if(fabs(1.0 - theta/90.0) < tol &&  dir==CW ) dx *= -1;
		if(fabs(1.0 - theta/270.0) < tol && dir==CCW ) dx *= -1;
	}
	else if(slope > 1e5)
	{	/* infinite slope */
		dx = 0.0;
		dy = arrowlen;
		if(fabs(1.0 - theta/180.0) < tol && dir==CW ) dy *= -1;
		if((fabs(1.0 - theta/360.0) < tol || fabs(theta) < theta_tol) && dir==CCW ) dy *= -1;
	}
	else
	{	/* normal slope */
		dx = arrowlen/sqrt(1+slope*slope);
		dy = fabs(dx*slope);
	}
	/* adjust sign */
	if(theta > 0 && theta < 90)
	{	/* quad 1 */
		if(dir==CW){dx*=-1;}else if(dir==CCW){dy*=-1;}
	}
	else if(theta > 90 && theta < 180)
	{	/* quad 2 */
		if(dir==CW){dx*=-1;dy*=-1;}
	}
	else if(theta > 180 && theta < 270)
	{	/* quad 3 */
		if(dir==CW){dy*=-1;}else if(dir==CCW){dx*=-1;}
	}
	else if(theta > 270 && theta < 360)
	{	/* quad 4 */
		if(dir==CCW){dy*=-1;dx*=-1;}
	}
	*x2 = *x1 + dx;
	*y2 = *y1 + dy;
}

void g_g_elliptical_arc(dbl rx,dbl ry,dbl t1,dbl t2,dbl cx,dbl cy,int marrow,int can_fillpath, int dir)
{
	/* if dir == 0 the arc if dir == 1 then narc */
	dbl x,y,x1,y1,x2,y2,length,slope,dx,dy;
	enum arrow_direction adir_start,adir_end;
	if(dir==0)
	{	/* arc */
		adir_start=CCW;
		adir_end=CW;
	}
	else
	{	/*narc*/
		adir_start=CW;
		adir_end=CCW;
	}
	/* if arrow is specified */
	/* assume arrow len in half current hei */
	g_get_hei(&length);
	length = length/2;
	g_get_xy(&x,&y);
	if ( marrow == 1 || marrow == 3 )
	{
		/* arrow -- start or both */
		/* compute slope of tangent line of ellipse
		and starting (x1,y1) and ending (x2,y2) of arrow*/
		get_elliptical_arrow_pos(x,y,t1,rx,ry,length,&x1,&y1,&x2,&y2,adir_start);
		if (!can_fillpath)
			g_arrow(x2-x1,y2-y1);
		else
			g_psarrow(x1,y1,x2,y2,2);
	}
	/* draw the arc */
	if(dir == 0) g.dev->elliptical_arc(rx,ry,t1,t2,cx,cy);
	if(dir == 1) g.dev->elliptical_narc(rx,ry,t1,t2,cx,cy);
	if( marrow == 2 || marrow == 3 )
	{
		/* arrow -- end or both */
		get_elliptical_arrow_pos(x,y,t2,rx,ry,length,&x1,&y1,&x2,&y2,adir_end);
		if (!can_fillpath)
			g_arrow(x2-x1,y2-y1);
		else
			g_psarrow(x1,y1,x2,y2,2);
	}
	g.xinline = true;
	if ((cx!=g.curx) || (cy!=g.cury))
	{
		g.curx = cx;/* + rx*cos(PI*t2/180);*/
        g.cury = cy;/* + ry*sin(PI*t2/180);*/
    }
}

void g_elliptical_arc(dbl rx,dbl ry,dbl t1,dbl t2,dbl cx,dbl cy,int marrow,int can_fillpath)
{
	g_g_elliptical_arc(rx,ry,t1,t2,cx,cy, marrow,can_fillpath, 0);
}

void g_elliptical_narc(dbl rx,dbl ry,dbl t1,dbl t2,dbl cx,dbl cy, int marrow,int can_fillpath)
{
	g_g_elliptical_arc(rx,ry,t1,t2,cx,cy, marrow,can_fillpath, 1);
}

/*---------------------------------------------------------------------------*/
void g_bezier(dbl x1,dbl y1,dbl x2,dbl y2,dbl x3,dbl y3)
{
        double x,y;
        g.dev->bezier(x1,y1,x2,y2,x3,y3);
        if (g.xinline==false) {
                g.xinline = true;
                g_set_bounds(g.curx,g.cury);
        }
        g.curx = x3;
        g.cury = y3;
        g_set_bounds(x3,y3);
}
/*---------------------------------------------------------------------------*/
void g_dmove(double x, double y)
{
        double ux,uy;
        g_undev(x,y,&ux,&uy);
        g.dev->move(ux,uy);
        g.curx = ux;
        g.cury = uy;
}
/*---------------------------------------------------------------------------*/
void g_dline(double x, double y)
{
        double ux,uy;
        g_undev(x,y,&ux,&uy);
        g.dev->line(ux,uy);
        g.curx = ux;
        g.cury = uy;
}
/*---------------------------------------------------------------------------*/
void g_dbezier(dbl x1,dbl y1,dbl x2,dbl y2,dbl x3,dbl y3)
{
        double a1,b1,a2,b2,a3,b3;
        g_undev(x1,y1,&a1,&b1);
        g_undev(x2,y2,&a2,&b2);
        g_undev(x3,y3,&a3,&b3);
        g_bezier(a1,b1,a2,b2,a3,b3);
        g.curx = a3;
        g.cury = b3;
}
/*---------------------------------------------------------------------------*/
void g_set_rgbf(double rr, double gg, double bb, double ff)
{
        /* Fill pattern is left as-is */
        g.color.b[B_R] = (unsigned char) rr*255;
        g.color.b[B_G] = (unsigned char) gg*255;
        g.color.b[B_B] = (unsigned char) bb*255;
        g.color.b[B_F] = (unsigned char) ff*255;
        g.dev->set_color(g.color.l);
}
void g_set_rgbf_fill(double rr, double gg, double bb, double ff)
{
        /* Fill pattern is left as-is */
        g.fill.b[B_R] = (unsigned char) rr*255;
        g.fill.b[B_G] = (unsigned char) gg*255;
        g.fill.b[B_B] = (unsigned char) bb*255;
        g.fill.b[B_F] = (unsigned char) ff*255;
        g.dev->set_fill(g.fill.l);
}
void g_get_rgbf(double *rr, double *gg, double *bb, double *ff)
{
        *rr = g.color.b[B_R]/255;
        *gg = g.color.b[B_G]/255;
        *bb = g.color.b[B_B]/255;
        *ff = g.color.b[B_F]/255;
}
/*---------------------------------------------------------------------------*/
void g_set_color(int l) {
        if (l==0) return;
        g.color.l = l;
        g.dev->set_color(g.color.l);
}

void g_get_color(int *l) {
        *l = g.color.l;
}

void g_get_colortyp(colortyp *color) {
        *color = g.color;
}

void g_colortyp_to_rgb01(colortyp* c1, rgb01 *c2) {
        c2->red = (double)c1->b[B_R]/255;
        c2->green = (double)c1->b[B_G]/255;
        c2->blue = (double)c1->b[B_B]/255;
}

int g_is_black(colortyp* color) {
	return color->b[B_R] == 0 && color->b[B_G] == 0 && color->b[B_B] == 0;
}
/*---------------------------------------------------------------------------*/
void g_set_fill(int l)
{
        g.fill.l = l;
        g.dev->set_fill(g.fill.l);
}
void g_get_fill(int *l)
{
        *l = g.fill.l;
}
/*---------------------------------------------------------------------------*/
void g_beginclip() {
        g.dev->beginclip(); }
void g_endclip() {
        g.dev->endclip(); }
/*---------------------------------------------------------------------------*/

void g_gsave()
{
        ngsave++;
        if (ngsave>=99) {
                gprint("Over 99 GSAVE's, probably a loop in your code\n");
                return;
        }
        gsave[ngsave] = (char*) myallocz(SIZEOFSTATE+10);
        g_get_state(gsave[ngsave]);
}
void g_grestore()
{
        static double a,b;
        g_flush();
        if (ngsave==0) {
                gprint("Attempt to GRESTORE at top of stack\n");
                if (gle_debug>0) a = a/b;
                return;
        }
        g_set_state(gsave[ngsave]);
        myfree(gsave[ngsave]);
        ngsave--;
}
void g_get_state(char *s)
{
        memcpy(s,&g,SIZEOFSTATE);
}
void g_set_state(char *s)
{
        memcpy(tmpimg,g.image,GLE_TRNS_MATRIX_SIZE);
        memcpy(&g,s,SIZEOFSTATE);
        memcpy(tmpimg2,g.image,GLE_TRNS_MATRIX_SIZE);
        memcpy(g.image,tmpimg,GLE_TRNS_MATRIX_SIZE);
        g_set_matrix(tmpimg2);
        g.dev->set_color(g.color.l);
        g.dev->set_fill(g.fill.l);
        g.dev->set_line_width(g.lwidth);
        g.dev->set_line_style(g.lstyle);
        g.dev->set_line_styled(g.lstyled);
        test_unit();
}
        /*                 12,4,-.5,-.5,0.35,        original dot */
struct mark_struct { int ff; int cc; double rx; double ry; double scl;};
struct mark_struct minf[61];
extern char *mrk_name[];
extern char *mrk_fname[];

/* struct mark_struct { int ff, int cc, double rx, double ry, double scl;}; */
extern char *mark_name[];
extern char *mark_sub[];
extern int mark_subp[];
extern int nmark;
extern int nmrk;

void g_marker(int i, double sz)
{
        g_marker2(i,sz,1.0);
}

void g_marker2(int i, double sz, double dval) throw(ParserError) {
	static double cx,cy,h,scale;
	static double x1,y1,x2,y2;
	int otype;
	if (i<0) {
		char *stk_str[6];
		double stk[6];
		int nstk=2;
		++i;
		i = -i;
		if (mark_subp[i] == -1) {
			int idx,zret,np,plist;
			GLESub* sub = sub_find(mark_sub[i]);
			mark_subp[i] = sub != NULL ? sub->getIndex() : -1;
			if (mark_subp[i] == -1)  {
				stringstream err;
				err << "subroutine '" << mark_sub[i] << "', which defines marker '" << mark_name[i] << "' not found";
				g_throw_parser_error(err.str());
			} else if (sub->getNbParam() != 2) {
				stringstream err;
				err << "subroutine '" << mark_sub[i] << "', which defines marker '" << mark_name[i] << "' should take two parameters (size and data), not " << sub->getNbParam();
				g_throw_parser_error(err.str());			
			}
		}
		stk[1] = sz;
		stk[2] = dval;
		g_get_xy(&cx,&cy);
		sub_call(mark_subp[i], (double *)&stk, (char **)&stk_str, &nstk, &otype);
		g_move(cx,cy);
		return;
	}
	if (i<1 || i>nmrk) {gprint("Invalid marker number %d \n",i); return;}
	g_get_xy(&cx,&cy);
	g_get_hei(&h);
	i--;
	scale = minf[i].scl*sz;
	g_set_hei(scale);
	if (minf[i].ff == 0) minf[i].ff = pass_font(mrk_fname[i]);
	if (minf[i].ff == -1) {
		minf[i].ff = pass_font(mrk_fname[i]);
		char_bbox(minf[i].ff,minf[i].cc,&x1,&y1,&x2,&y2);
		minf[i].ry = (minf[i].ry + -y1-(y2-y1)/2.0);
		minf[i].rx = (minf[i].rx + -x1-(x2-x1)/2.0);
	}
	g_move(cx+minf[i].rx*scale, cy+minf[i].ry*scale);
	g_char(minf[i].ff,minf[i].cc);
	g_move(cx,cy);
	g_set_hei(h);
}

void g_defmarker(char *mname,char *font, int ccc, double dx, double dy, double sz, int autodx) {
        int i;
        if (nmrk>61-1) {gprint("Too many markers defined \n"); return;}
        i = nmrk;
        nmrk++;
        mrk_name[i] = sdup(mname);
        mrk_fname[i] = sdup(font);
        minf[i].ff = 0;
        if (autodx) minf[i].ff = -1;
        minf[i].cc = ccc;
        minf[i].rx = dx;
        minf[i].ry = dy;
        minf[i].scl = sz;
}
void g_marker_def(char *mname,char *subname)
{
        int i;
        for (i=0; i<nmark; i++) if (str_i_equals(mname,mark_name[i])) {
                myfree(mark_name[i]);
                myfree(mark_sub[i]);
                nmark--;
                break;
        }
        nmark++;
        mark_name[i] = sdup(mname);
        mark_sub[i] = sdup(subname);
        mark_subp[i] = -1;
}
void g_char(int font, int cc)
{
        g.dev->dochar(font,cc);
}
void g_text(char *ss)
{
        text_block(UC ss,0.0,g.just);
}
void g_set_just(int jj)
{
        g.just = jj;
}
void g_set_font(int jj)
{
        if (jj==0) return;
        font_load_metric(jj);
        g.fontn = jj;
}
void g_set_hei(double h)
{
        if (h==0) {
                gprint("========================************ HEIGHT SET TO ZERO\n");
                return;
        }
        g.fontsz = h;
}
void g_get_just(int *jj)
{
        *jj = g.just;
}
void g_get_font(int *jj)
{
        *jj = (int) g.fontn;
}
void g_get_hei(double *h)
{
        *h = g.fontsz;
}
void g_postscript(char *fname,double wx, double wy)
{
	/*
	fname ... the filename
	wx .... the users desired width  in GLE units
	wy .... the users desired height in GLE units
	*/
	char inbuff[200];
	FILE *fptr;
	int i;
	char *s;
	double bx1=0,by1=0,bx2,by2,x,y,cx,cy;
	g_get_type(inbuff);
	if (str_i_str(inbuff,"PS")== NULL) {
		g_get_xy(&cx,&cy);
		g_box_stroke(cx,cy,cx+wx,cy+wy);
		return;
	}
	fptr = fopen(fname,"r");
	if (fptr==NULL) {
		gprint("Unable to open input file {%s} \n",fname);
		exit(1);
	}
	for (;!feof(fptr);) {
		if (fgets(inbuff,190,fptr)!=NULL) {
			if (str_ni_equals(inbuff,"%%BoundingBox:",14)) {
				s = strtok(inbuff," :\t");
				bx1 = atof(strtok(0," :\t"));
				by1 = atof(strtok(0," :\t"));
				bx2 = atof(strtok(0," :\t"));
				by2 = atof(strtok(0," :\t"));
				// do not get confused by second bounding box
				break;
			}
		}
	}
	gbox save_box;
	g_get_bounds_box(&save_box);
	g_devcmd("/GLESTATE save def \n");
	g_devcmd("gsave\n");
	g_devcmd("/a4small {} def /legal {} def\n");
	g_devcmd("/letter {} def /note {} def /copypage {} def \n");
	g_devcmd("/erasepage {} def /showpage {} def \n");
	rewind(fptr);
	g_gsave();
	g_get_xy(&cx,&cy);
	bx2 -= bx1;
	by2 -= by1;
	if (bx2==0 || by2==0) {gprint("Invalid EPS file\n"); return;}
	if (fabs(wy) < 1e-6) {
		wy = wx*by2/bx2;
	} else if (fabs(wx) < 1e-6) {
		wx = wy*bx2/by2;
	}
	g_scale(wx/bx2, wy/by2);
	g_translate(-bx1+cx*wx/bx2,-by1+cy*wx/bx2);
	g_devcmd("0 setgray 0 setlinecap 0 setlinewidth 0 setlinejoin\n");
	g_devcmd("10 setmiterlimit [] 0 setdash\n");
	g_devcmd(inbuff);
	for (;!feof(fptr);) {
		if (fgets(inbuff,190,fptr) != NULL) {
			if (!str_ni_equals(inbuff,"%%BoundingBox:",strlen("%%BoundingBox:")) &&
			    !str_ni_equals(inbuff,"%%EOF",strlen("%%EOF"))) {
				g_devcmd(inbuff);
			}
		}
	}
	fclose(fptr);
	g_devcmd("grestore GLESTATE restore \n");
	g_grestore();
	/* Adjust bounds */
	g_restore_bounds(&save_box);
	g_set_bounds(cx, cy);
	g_set_bounds(cx+wx, cy+wy);
}

int check_dev_type_ps(double wx, double wy) {
	char devtype[200];
	g_get_type(devtype);
	if (str_i_str(devtype,"PS")== NULL) {
		gprint("Ouput device does not support BITMAPS\n");
		double cx, cy;
		g_get_xy(&cx,&cy);
		g_box_stroke(cx,cy,cx+wx,cy+wy);
		return 0;
	} else {
		return 1;
	}
}

#ifdef __TIFF__
typedef void (*TIFFWarningHandler)(const char* module, const char* fmt, va_list ap);
#endif

int g_bitmap_string_to_type(const char* stype) {
	if (str_i_equals(stype, "tiff")) {
		return BITMAP_TYPE_TIFF;
	} else if (str_i_equals(stype, "tif")) {
		return BITMAP_TYPE_TIFF;
	} else if (str_i_equals(stype, "gif")) {
		return BITMAP_TYPE_GIF;
	} else if (str_i_equals(stype, "png")) {
		return BITMAP_TYPE_PNG;
	} else if (str_i_equals(stype, "jpg")) {
		return BITMAP_TYPE_JPEG;
	} else if (str_i_equals(stype, "jpeg")) {
		return BITMAP_TYPE_JPEG;
	} else {
		gprint("Unknown bitmap type: %s, please supply one of: [TIFF, GIF, PNG, JPEG]", stype);
		return 0;
	}
}

void g_update_bitmap_type(const string& fname, int* type) {
	if (*type == 0) {
		string ext;
		GetExtension(fname, ext);
		*type = g_bitmap_string_to_type(ext.c_str());
	}
}

void g_bitmap_type_to_string(int type, string &typestr) {
	switch (type) {
		case BITMAP_TYPE_TIFF:
			typestr = "TIFF"; break;
		case BITMAP_TYPE_GIF:
			typestr = "GIF"; break;
		case BITMAP_TYPE_PNG:
			typestr = "PNG"; break;
		case BITMAP_TYPE_JPEG:
			typestr = "JPEG"; break;
	}
}

GLEBitmap* g_bitmap_type_to_object(int type) {
	switch (type) {
		case BITMAP_TYPE_TIFF:
			#ifdef __TIFF__
				return new GLETIFF();
			#else
				return NULL;
			#endif
		case BITMAP_TYPE_GIF:
			return new GLEGIF();
		case BITMAP_TYPE_PNG:
			#ifdef __PNG__
				return new GLEPNG();
			#else
				return NULL;
			#endif
		case BITMAP_TYPE_JPEG:
			return new GLEJPEG();
		default:
			return NULL;
	}
}

void g_bitmap(string& fname, double wx, double wy, int type) {
	double cx, cy;
	gbox save_box;
	if (check_dev_type_ps(wx, wy) == 0) {
		// Not a postscript device, do not support bitmaps
		return;
	}
	g_update_bitmap_type(fname, &type);
	if (type == 0) {
		// Unknown bitmap type
		return;
	}
	FILE* fpout = g.dev->get_file_pointer();
	if (fpout == NULL) {
		gprint("Ouput device does not support BITMAPS\n", fname.c_str());
		return;
	}
	/* Get bitmap type string */
	string typestr;
	g_bitmap_type_to_string(type, typestr);
	/* Get bitmap writer object */
	GLEBitmap* bitmap = g_bitmap_type_to_object(type);
	if (bitmap == NULL) {
		gprint("Support for %s bitmaps not enabled", typestr.c_str());
		return;
	}
	/* Open file */
	if (bitmap->open(fname) == 0) {
		gprint("Can't open bitmap file: %s", fname.c_str());
		delete bitmap;
		return;
	}
	/* Read header */
	int result = bitmap->readHeader();
	if (result != GLE_IMAGE_ERROR_NONE) {
		gprint("Error reading bitmap header: %s, code = %d", fname.c_str(), result);
		delete bitmap;
		return;
	}
	/* Store current box */
	g_get_bounds_box(&save_box);
	/* Generate header in postrscript output */
	g_devcmd("%%==========================================\n");
	string str = string("%% BEGIN inclusion of ") + typestr+ " image: " + fname + "\n";
	g_devcmd((char*)str.c_str());
	g_devcmd("%%==========================================\n");
	g_devcmd("/GLESTATE save def \n");
	g_devcmd("gsave\n");
	g_devcmd("0 setgray 0 setlinecap 0 setlinewidth 0 setlinejoin\n");
	g_devcmd("10 setmiterlimit [] 0 setdash\n");
	g_gsave();
	/* Get current point */
	g_get_xy(&cx,&cy);
	/* Update scale */
	if (wx == 0.0 || wy == 0.0) {
		double bw = bitmap->getWidth();
		double bh = bitmap->getHeight();
		if (wx == 0.0 && bh != 0.0) {
			wx = wy*bw/bh;
		}
		if (wy == 0.0 && bw != 0.0) {
			wy = wx*bh/bw;
		}
	}
	/* Set options */
	bitmap->setCompress(0.0);
	bitmap->setASCII85(1);
	/* Get current position	*/
	g_scale(wx,wy);
	g_translate(cx,cy);
	/* Convert bitmap to postscript */
	bitmap->toPS(fpout);
	bitmap->close();
	/* Footer */
	g_devcmd("grestore GLESTATE restore \n");
	g_grestore();
	g_devcmd("%%==========================================\n");
	str = string("%% END inclusion of ") + typestr+ " image: " + fname + "\n";
	g_devcmd((char*)str.c_str());
	g_devcmd("%%==========================================\n");
	/* Output info */
	cout << "{" << bitmap->getFName() << "-";
	bitmap->printInfo(cout);
	cout << "}";
	/* Adjust bounds */
	g_restore_bounds(&save_box);
	g_set_bounds(cx, cy);
	g_set_bounds(cx+wx, cy+wy);
	/* Don't forget to delete */
	delete bitmap;
}

void g_bitmap_info(string& fname, int xvar, int yvar, int type) {
	g_update_bitmap_type(fname, &type);
	if (type == 0) {
		// Unknown bitmap type
		return;
	}
	/* Get bitmap type string */
	string typestr;
	g_bitmap_type_to_string(type, typestr);
	/* Get bitmap writer object */
	GLEBitmap* bitmap = g_bitmap_type_to_object(type);
	if (bitmap == NULL) {
		gprint("Support for %s bitmaps not enabled (%s)", typestr.c_str(), fname.c_str());
		return;
	}
	/* Open file */
	if (bitmap->open(fname) == 0) {
		gprint("Can't open bitmap file: %s", fname.c_str());
		delete bitmap;
		return;
	}
	/* Read header */
	int result = bitmap->readHeader();
	if (result != GLE_IMAGE_ERROR_NONE) {
		gprint("Error reading bitmap header: %s, code = %d", fname.c_str(), result);
		delete bitmap;
		return;
	}
	var_set(xvar, (double)bitmap->getWidth());
	var_set(yvar, (double)bitmap->getHeight());
	bitmap->close();
	delete bitmap;
}

void g_arrowline(double x2, double y2, int flag, int can_fillpath) {
	double x1,y1;
	if ((flag&3)==0) {
		g_line(x2,y2);
		return;
	}
	g_get_xy(&x1,&y1);
	if (!can_fillpath) {
		if (flag & 1)  g_arrow(x2-x1,y2-y1);
		g_line(x2,y2);
		if (flag & 2)  g_arrow(x1-x2,y1-y2);
		return;
	}
	g_psarrow(x1,y1,x2,y2,flag);
}

void g_arrow(double dx, double dy, int can_fillpath) {
	if (can_fillpath) {
		double x1, y1, ax1, ax2, ay1, ay2, nx, ny;
		int cur_color;
		g_get_xy(&x1,&y1);
		g_arrowpoints(x1, y1, dx, dy, &ax1, &ay1, &ax2, &ay2, &nx, &ny);
		g_set_path(true);
		g_newpath();
		g_move(ax2,ay2);
		g_line(x1,y1);
		g_line(ax1,ay1);
		g_closepath();
		x1 = nx; y1 = ny;
		g_get_color(&cur_color);
		g_set_fill(cur_color);
		g_fill();
		g_set_path(false);
		g_newpath();
	} else {
		g_arrow(dx, dy);
	}
}

void g_psarrow(double x1, double y1, double x2, double y2, int flag) {
	double ax1,ax2,ay1,ay2,dx,dy,nx,ny,nnx,nny,xx2,yy2;
	int cur_color;
	xx2 = x2; yy2 = y2;
	dx = x2-x1;  dy = y2-y1;
	g_arrowpoints(x1,y1,dx,dy,&ax1,&ay1,&ax2,&ay2,&nx,&ny);
	g_set_path(true);
	g_newpath();
	if ((flag & 1)>0) {
		g_move(ax2,ay2);
		g_line(x1,y1);
		g_line(ax1,ay1);
		g_closepath();
		x1 = nx; y1 = ny;
	}
 	g_arrowpoints(x2,y2,-dx,-dy,&ax1,&ay1,&ax2,&ay2,&nx,&ny);
	if ((flag & 2)>0) {
		g_move(ax2,ay2);
		g_line(x2,y2);
		g_line(ax1,ay1);
		g_closepath();
		xx2 = nx; yy2 = ny;
	}
	g_get_color(&cur_color);
	g_set_fill(cur_color);
	g_fill();
	g_set_path(false);
	g_newpath();
	g_move(x1,y1);
	g_line(xx2,yy2);
	g_move(x2,y2);
}

void g_arrowsize(double *len, double *angle) {
	double width;
	double arrow_len = g.arrowsize;
	double arrow_angle = g.arrowangle;
	g_get_line_width(&width);
	if (width == 0) width = 0.02;
	if (arrow_angle <= 0.0) {
		arrow_angle = 10;
		if (width > 0.1) arrow_angle = 20;
		if (width > 0.3) arrow_angle = 30;
	}
	if (arrow_len <= 0.0) {
		g_get_hei(&arrow_len);
		arrow_len = arrow_len/2;
		if (sin(arrow_angle*GLE_PI/180)*arrow_len < width/1.5) {
			arrow_len = (width/1.5) / sin(arrow_angle*GLE_PI/180);
		}
	}
	*len = arrow_len;
	*angle = arrow_angle;
}

void g_arrowpoints(double cx,double cy,double dx,double dy, double *ax1,
	double *ay1,double *ax2,double *ay2, double *nnx, double *nny) {
	double radius,angle,alen,nx,ny,arrow_angle;
	g_arrowsize(&alen, &arrow_angle);
	xy_polar(dx,dy,&radius,&angle);
	if (radius<0) alen = -alen;
	polar_xy(alen,angle+arrow_angle,&dx,&dy);
	*ax2 = cx+dx;  *ay2 = cy+dy;
	polar_xy(alen,angle-arrow_angle,&dx,&dy);
	*ax1 = cx+dx;  *ay1 = cy+dy;
	polar_xy(alen*cos(arrow_angle*GLE_PI/180),angle,&nx,&ny);
	cx += nx; cy += ny;
	*nnx = cx; *nny = cy;
}

void g_arrow(double dx, double dy) {
	double cx,cy,radius,angle,alen,arrow_angle;
	g_get_xy(&cx,&cy);
	g_arrowsize(&alen, &arrow_angle);
	xy_polar(dx,dy,&radius,&angle);
	if (radius<0) alen = -alen;
	polar_xy(alen,angle+arrow_angle,&dx,&dy);
	g_line(cx+dx,cy+dy);
	g_move(cx,cy);
	polar_xy(alen,angle-arrow_angle,&dx,&dy);
	g_line(cx+dx,cy+dy);
	g_move(cx,cy);
}

void g_set_arrow_size(double size) {
	g.arrowsize = size;
}

void g_set_arrow_angle(double angle) {
	g.arrowangle = angle;
}

void g_set_pdf_image_format(const char* format) {
	if (str_i_equals(format, "AUTO")) {
		g.pdfimgformat = PDF_IMG_COMPR_AUTO;
	} else if (str_i_equals(format, "ZIP")) {
		g.pdfimgformat = PDF_IMG_COMPR_ZIP;
	} else if (str_i_equals(format, "JPEG")) {
		g.pdfimgformat = PDF_IMG_COMPR_JPEG;
	} else if (str_i_equals(format, "PS")) {
		g.pdfimgformat = PDF_IMG_COMPR_PS;
	}
}

int g_get_pdf_image_format() {
	return g.pdfimgformat;
}

GLEDevice::GLEDevice() {
}

GLEDevice::~GLEDevice() {
}

