#include <ctype.h>
#include <stdio.h>
#include <math.h>

// For visual C++ -- should use numeric limits?
#if defined(__WIN32__) && !defined(__NOCYGWIN__)
#include<float.h>
	#define isnan _isnan
	#define isinf _isnan
#endif

// OS/2 (gcc) has no isinf() (???), fake it
#if defined(__OS2__) && !defined(isinf)
#define isinf(f) 0
#endif

int gle_isnan(double v) {
	// Do not include <iostream> or <cmath> before gle_isnan
	// otherwise gle_isnan wil break on Mac OS/X and OS/2
	return isnan(v);
}

int gle_isinf(double v) {
	// Do not include <iostream> or <cmath> before gle_isinf
	// otherwise gle_isinf wil break on Mac OS/X and OS/2
	return isinf(v);
}

#include <string>
#include <vector>
#include <sstream>

using namespace std;

namespace {
    char * gle_strupr(char *s) {
        char *tmp = s;
        while (*s != 0) {
            *s = toupper(*s);
            s++;
        }
        return tmp;
    }

    char * gle_strlwr(char *s) {
        char *tmp = s;
        while (*s != 0) {
            *s = tolower(*s);
            s++;
        }
        return tmp;
    }
}

bool gle_onlyspace(const string& s) {
	string::size_type len = s.length();
	for (string::size_type i = 0; i < len; i++) {
		if (s[i] != ' ' && s[i] != '\t') return false;
	}
	return true;
}

bool gle_isnumber(const char *s) {
	while (*s!='\0') {
		if (isdigit(*s) || *s=='.' || toupper(*s)=='E' ) s++;
		else  return false;
	}
	return true;
}

const char* str_skip_brackets(const char* s, int ch1, int ch2) {
	int depth = -1;
	while (*s != 0) {
		if (*s == ch1) {
			depth++;
		} else if (*s == ch2) {
			depth--;
			if (depth <= 0) break;
		}
		s++;
	}
	return s;
}

bool str_i_equals(const char* s1, const char* s2) {
	int i = 0;
	while (s1[i] != 0 && s2[i] != 0) {
		if (toupper(s1[i]) != toupper(s2[i])) return false;
		i++;
	}
	return s1[i] == 0 && s2[i] == 0;
}

bool str_ni_equals(const char* s1, const char* s2, int max) {
	int i = 0;
	while (s1[i] != 0 && s2[i] != 0 && i < max) {
		if (toupper(s1[i]) != toupper(s2[i])) return false;
		i++;
	}
	if (i == max) return true;
	return s1[i] == 0 && s2[i] == 0;
}

int str_i_cmp(const char* s1, const char* s2) {
        char* s1_copy = new char[strlen(s1) + 1];
        strcpy(s1_copy, s1);

        char* s2_copy = new char[strlen(s2) + 1];
        strcpy(s2_copy, s2);

        int result = strcmp(gle_strupr(s1_copy), gle_strupr(s2_copy));
        delete[] s1_copy;
        delete[] s2_copy;

        return result;
}

char* str_i_str(const char* haystack, const char* needle) {
	int endIndex = strlen(haystack);
	int patternLength = strlen(needle);
	int endPattern = endIndex - patternLength + 1;
	if (endPattern < 0) {
		return NULL;
	}
	if (patternLength <= 0) {
		return (char*)haystack;
	}
	char patternChar0 = toupper(needle[0]);
	for (int ctrSrc = 0; ctrSrc <= endPattern; ctrSrc++) {
		if (toupper(haystack[ctrSrc]) != patternChar0) {
			continue;
		}
		int ctrPat;
		for (ctrPat = 1; (ctrPat < patternLength) && (toupper(haystack[ctrSrc + ctrPat]) == toupper(needle[ctrPat])); ctrPat++) {
			; // just loop
		}
		if (ctrPat == patternLength) {
			return (char*)haystack+ctrSrc;
		}
	}
	return NULL;
}

bool str_i_equals(const string& s1, const char* s2) {
	int l1 = s1.length();
	for (int i = 0; i < l1; i++) {
		if (toupper(s1[i]) != toupper(s2[i])) return false;
	}
	return true;
}

bool str_i_equals(const string& s1, const string& s2) {
	int l1 = s1.length();
	int l2 = s2.length();
	if (l1 != l2) return false;
	for (int i = 0; i < l1; i++) {
		if (toupper(s1[i]) != toupper(s2[i])) return false;
	}
	return true;
}

int str_starts_with_trim(string& str, const char* test) {
	int len = str.length();
	int pos = 0;
	while (pos < len && (str[pos] == ' ' || str[pos] == '\t')) {
		pos++;
	}
	int idx = 0;
	while (pos < len && toupper(test[idx]) == toupper(str[pos])) {
		idx++;
		pos++;
	}
	if (test[idx] == 0) return pos;
	else return -1;
}

bool str_contains(const char* str, char ch) {
	int i = 0;
	while (str[i] != 0 && str[i] != ch) {
		i++;
	}
	return str[i] == ch;
}

void str_prefix(int count, char ch, string* str) {
	if (count > 0) {
		stringstream prefix;
		for (int i = 0; i < count; i++) {
			prefix << ch;
		}
		prefix << (*str);
		*str = prefix.str();
	}
}

void str_to_uppercase(const string& input, string& output) {
	output = input;
	int len = input.length();
	for (int i = 0; i < len; i++) {
		output[i] = toupper(output[i]);
	}
}

void str_to_uppercase(string& output) {
	int len = output.length();
	for (int i = 0; i < len; i++) {
		output[i] = toupper(output[i]);
	}
}

void str_remove_quote(string& str) {
	int len = str.length();
	if (len >= 2) {
		if ((str[0] == '\"' && str[len-1] == '\"') || (str[0] == '\'' && str[len-1] == '\'')) {
			str.erase(len-1);
			str.erase(0, 1);
		}
	}
}

void str_try_add_quote(string& str) {
	if (str.find(' ') == string::npos) return;
	str.insert(0, "\"");
	str += "\"";
}

void str_trim_right(string& str) {
	int len = str.length();
	if (len > 0) {
		char ch;
		bool is_space;
		int pos = len;
		do {
			pos--;
			ch = str.at(pos);
			is_space = (ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n');
		} while (pos > 0 && is_space);
		if (pos == 0 && is_space) {
			str = "";
		} else if (pos < len-1) {
			str.erase(pos+1);
		}
	}
}

void str_trim_left(string& str) {
	int len = str.length();
	if (len > 0) {
		char ch;
		bool is_space;
		int pos = -1;
		do {
			pos++;
			ch = str.at(pos);
			is_space = (ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n');
		} while (pos < len-1 && is_space);
		if (pos >= len-1 && is_space) {
			str = "";
		} else if (pos > 0) {
			str.erase(0,pos);
		}
	}
}

void str_trim_both(string& str) {
	str_trim_right(str);
	str_trim_left(str);
}

void gle_int_to_string(int value, string* str) {
	char str_value[80];
	sprintf(str_value, "%d", value);
	*str = str_value;
}

int gle_double_digits(double value, int prec) {
	int digits = (int)floor(log10(value));
	// Round value to desired precision, and check if overflows, i.e., > 10
	value = floor(value / pow(10.0, digits-prec+1)+0.5+1e-6) / pow(10.0, prec-1);
	return value >= 10.0 ? digits+1 : digits;
}

int gle_int_digits(int value) {
	return (int)floor(log10((double)value));
}

void gle_int_to_string_bin(int value, string* binary) {
	vector<unsigned char> values;
	while (value > 0) {
		values.push_back((unsigned char)(value % 2));
		value /= 2;
	}
	stringstream out;
	for (int i = values.size()-1; i >= 0; i--) {
		out << (int)values[i];
	}
	*binary = out.str();
}

int lastchar(char *s, char c) {
	while (*s != '\0') { s++; }
	return *(--s) == c;
}

char *un_quote(char *cts) {
	int i,j;
	i = strlen(cts);
	if (*cts == '"') {
		*(cts+i-1) = 0;
		cts = cts + 1;
	}
	return cts;
}
