#ifndef GUARD_cutils_h
#define GUARD_cutils_h

bool gle_onlyspace(const string& s);
bool gle_isnumber(const char *s);

int gle_isnan(double v);
int gle_isinf(double v);

const char* str_skip_brackets(const char* s, int ch1, int ch2);

// for compatibility between different compilers
bool str_i_equals(const char* s1, const char* s2);
bool str_ni_equals(const char* s1, const char* s2, int max);
int str_i_cmp(const char* s1, const char* s2);
char* str_i_str(const char* haystack, const char* needle);
bool str_i_equals(const string& s1, const string& s2);

bool str_contains(const char* str, char ch);

void str_prefix(int count, char ch, string* str);

void str_to_uppercase(const string& input, string& output);

void str_to_uppercase(string& output);

void str_trim_both(string& str);

void str_trim_right(string& str);

void str_trim_left(string& str);

int str_starts_with_trim(string& str, const char* test);

void str_remove_quote(string& str);

void str_try_add_quote(string& str);

void gle_int_to_string_bin(int value, string* binary);

void gle_int_to_string(int value, string* str);

int gle_double_digits(double value, int prec);

int gle_int_digits(int value);

char *un_quote(char *cts);

int lastchar(char *s, char c);

#endif
