#include <math.h>
#include <time.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <errno.h>
#include <list>
#include <math.h>
#include <time.h>
#include <string>
#include <sstream>
#include <iostream>
#include <vector>
#include <list>
#include <map>
using namespace std;

#include "tokens/stokenizer.h"
#include "SourceLine.h"
#include "all.h"
#include "tokens/Tokenizer.h"
#include "mem_limits.h"
#include "token.h"
#include "core.h"
#include "var.h"
#include "glearray.h"
#include "polish.h"
#include "pass.h"
#include "file_io.h"
#include "gprint.h"
#include "mygraph.h"
#include "run.h"
#include "cmdline.h"
#include "config.h"
#include "drawit.h"

#define dbg if (gle_debug>0)
extern int gle_debug;
extern int trace_on;
extern int this_line;
int *(*gpcode)[];   /* gpcode is a pointer to an array of poiter to int */
int (*gplen)[];   /* gpcode is a pointer to an array of int */
int ngpcode=0;
int ngerror;
extern int last_line;

void expand_pcode(int i, int *j);
char *dr_nextline(int *srclin);
void dr_init(void);
int getch(void);

int abort_flag;
static char inbuff[300];

void g_close();

string g_File;

int gle_is_open();

const string& get_input_file() {
	return g_File;
}

inline void Renumber(_GLESource &g) {
	_itGLESource itg = g.begin();
	int i = 1;
	while(itg != g.end()){
		itg->line_no = i++;
		itg++;
	}
}

/*---------------------------------------------------------------------------*/

void output_error(ParserError& err) {
	if (err.hasFlag(TOK_PARSER_ERROR_ATEND)) {
		err.setMessage("unexpected end of line");
	}
	if (err.hasFlag(TOK_PARSER_ERROR_PSTRING)) {
		g_set_error_column(-1);
		gprint(string(">> Error: ")+err.msg()+"\n");
		if (err.getColumn() != -1) {
			gprint(string(">> In: '")+err.getParserString()+"'\n");
			stringstream pos_strm;
			pos_strm << ">>";
			for (int i = 0; i < err.getColumn()+5; i++) {
				pos_strm << " ";
			}
			pos_strm << "^" << endl;
			gprint(pos_strm.str());
		}
	} else {
		g_set_error_column(err.getColumn());
		gprint(string(">> Error: ")+err.msg()+"\n");
	}
}

void output_error_cerr(ParserError& err) {
	if (err.hasFlag(TOK_PARSER_ERROR_ATEND)) {
		err.setMessage("unexpected end of line");
	}
	if (err.hasFlag(TOK_PARSER_ERROR_PSTRING)) {
		cerr << ">> Error: " << err.msg() << endl;
		if (err.getColumn() != -1) {
			cerr << ">> In: '" << err.getParserString() << "'" << endl;
			stringstream pos_strm;
			pos_strm << ">>";
			for (int i = 0; i < err.getColumn()+5; i++) {
				pos_strm << " ";
			}
			pos_strm << "^" << endl;
			cerr << pos_strm.str();
		}
	} else {
		cerr << ">> Error: " << err.msg() << endl;
	}
}

void DrawIt(char* input_file, _GLESource &gle_txt, CmdLineObj* cmdline, bool silent) {
	abort_flag = false;
	ngerror = 0;
	last_line = 0;
	if (!silent) {
		printf("GLE %s.%s [%s]-C",__VN__,__BN__,input_file);
		fflush(stdout);
	}
	g_File = input_file;
	g_clear();
	mark_clear();
	sub_clear();
	name_clear();
	for_init();
	clear_run();
	f_init();
	if (cmdline != NULL) {
		int devtype = g_get_device();
		if (devtype == GLE_DEVICE_PS) {
			g_set_fullpage(true);
		} else {
			g_set_fullpage(cmdline->hasOption(GLE_OPT_FULL_PAGE));
		}
	}
	g_set_pagesize(gle_config_papersize());
	g_set_margins(gle_config_margins());
	var_def("PI", GLE_PI);

	GLEPcodeList pc_list;
	GLEPcode pcode(&pc_list);

	int maxpcode=0;
	expand_pcode(gle_txt.size(),&maxpcode);
	ngpcode=0;

	GLEPolish polish;
	polish.initTokenizer();

	// Create tokenizer
	GLEParser parser(&polish);
	parser.initTokenizer();

	set_global_parser(&parser);

	_itGLESource lscli = gle_txt.begin();
	while(lscli != gle_txt.end()){
		// call passt to convert the tokens into PCode
		// pcode is simply numbers that instruct the drawing
		// engine which commands to draw

		// cout << "Line = " << *lscli;
		parser.setString(lscli->text.c_str());

		try {
			parser.passt(*lscli, pcode);
		} catch (ParserError err) {
			output_error(err);
		}

		bool add_pcode = true;
		if (parser.hasSpecial(GLE_PARSER_INCLUDE)){
			// this is a file to include load the file
			// and insert it into gle_txt here
			_GLESource IncludedText;
			if (!text_load_include(parser.getInclude(),IncludedText,lscli->line_no)) {
				gprint("Error can't open include file %s\n",parser.getInclude().c_str());
				exit(1);
			}
			// now insert here.
			// calling splice ensures pointer remain valid or so says the STL docs
			_itGLESource Save = lscli;
			Save--;
			// this puts in before lscli
			gle_txt.splice(lscli,IncludedText);
			gle_txt.erase(lscli); // dont need the include line anymore
			Renumber(gle_txt); // need to renumber all the global line numbers this is kninda kludegy VL
			lscli = Save; // put to first line of included text
			cout << "{" << parser.getInclude() << "}";
			//don't need this pcode
			add_pcode = false;
		}
		if (add_pcode){
			#ifdef NEW_WAY
			// not working due to need for global pcode!
			GlobalPCode.push_back(PCode);
			#else
			// copy the pcode into the global buffer
			if (ngpcode > maxpcode) expand_pcode(ngpcode*2,&maxpcode);
			(*gpcode)[++ngpcode] = pcode.size() == 0 ? NULL : (int*) myallocz(pcode.size()*sizeof(char *));
			(*gplen)[ngpcode] = pcode.size();
			memcpy((*gpcode)[ngpcode],&pcode[0],pcode.size()*sizeof(char *));
			#endif
		}
		pcode.clear();
		lscli++;
	}
	parser.checkmode();
	if (ngerror > 0){
		reset_new_error(true);
		g_message("\n>> Errors, aborting.\n");
		exit(0);
	}
	//
	// -- now run the pcode in the driver
	//
	if (!silent) printf("-R-");
	if(ngpcode != gle_txt.size()){
		cout << "error pcode and text size mismatch"<<endl;
		cout << "pcode size = " << ngpcode <<" text size = "<<gle_txt.size()<<endl;
	}
	token_space();
	try {
#ifdef NEW_WAY
		// not working due to global pcode
		lscli = gle_txt.begin();
		_itGlobalPCode itgp = GlobalPCode.begin();
		while(itgp != GlobalPCode.end()){
			do_pcode(*lscli,*itgp);
			lscli++;
			itgp++;
		}
#else
		int endp;
		lscli = gle_txt.begin();
		for (int i=1;i<=ngpcode;i++){
			this_line = i;
			//cout << i << " ";
			int Oldi = i;
			do_pcode(*lscli,&i,(*gpcode)[i],(*gplen)[i],&endp);
			//cout << i << " " << *lscli;
			// need to advance here since do_pcode may call for line skipping
			advance(lscli,i-Oldi+1);
		}
#endif
	} catch (ParserError err) {
		output_error(err);
	}
	if (!gle_is_open()) {
		// If .gle file is empty, create empty postscript file
		g_set_size(10, 10, false);
		g_open(get_input_file().c_str());
	}
	set_global_parser(NULL);
	g_reset_message();
	g_close();
}

void expand_pcode(int ngtxt,int *maxpcode)
{
        int *a,*b;
        a = (int*) myallocz((ngtxt+10)*sizeof(char *));
        b = (int*) myallocz((ngtxt+10)*sizeof(char *));
        if (gpcode!=0) {
                memcpy(a,gpcode,(*maxpcode + 4)*sizeof(char *));
                memcpy(b,gplen,(*maxpcode + 4)*sizeof(char *));
                myfrees(gpcode,"gpcode2");
                myfrees(gplen,"gplen");
        }
        gpcode = (int *(*)[]) a;
        gplen = (int (*)[]) b;
        *maxpcode = ngtxt+1;
}

