#include <math.h>
#include <time.h>
#include <string>
#include <sstream>
#include <iostream>
#include <vector>
#include <list>
#include <map>
#include <fstream>
#include <algorithm>
#include <unistd.h>
#ifdef __WIN32__
	#include <sys/types.h>
	#include <sys/stat.h>
	#include <stdlib.h>
	#include <process.h>
	#include <windows.h>
#endif
#if defined(__OS2__) && defined(__EMX__)
	#include <unistd.h>
#endif
using namespace std;
#include "tokens/stokenizer.h"
#include "SourceLine.h"
#include "all.h"
#include "errno.h"
#include "stdio.h"
#include "stdlib.h"
#include "file_io.h"
#include "cutils.h"

extern string GLE_TOP_DIR;

void CopyGLETop(char* buf);
string GetActualFilename(string fname);

int trace_on;

bool text_load_include(const string& fname, _GLESource &SL, int global_line_no) {
	string fullname = GetActualFilename(fname);
	if (fullname == "") {
		//printf("ERROR: File \"%s\" is not found.\nExiting.\n",fname.c_str());
		return false;
	} else {
		return text_load(fullname, fname, SL, global_line_no);
	}
}

bool text_load(const string& fname, _GLESource &SL, int global_line_no) {
	return text_load(fname, fname, SL, global_line_no);
}

bool text_load(const string& fullname, const string& fname, _GLESource &SL, int global_line_no) {
	// -- load the gle file called by main program and the include command
	//    fname .. the filename
	//    SL    .. STL list of source lines
	//    global_line_no is needed for renumbering include file...
	// returns true upon success false if it cant find the file
	//
	if (IsDirectory(fullname)) {
		//printf("ERROR: File \"%s\" is a directory.\nExiting.\n",fname.c_str());
		return false;
	}
	std::ifstream file;
	file.open(fullname.c_str());
	if (!file.is_open()){
		//printf("ERROR File %s is not found.\nExiting.\n",fullname.c_str());
		return false;
	}
	//
	// -- load the file and rememeber to look for continuation character
	//
	size_t line_no = 1;
	const char CONT_CHAR = '&';  // should be a global define somewhere??
	bool cont = false;
	string inbuff;
	while(!file.eof()){
		string linbuff;
		getline(file, linbuff);
		str_trim_right(linbuff);
		if (cont) {
			// -- splice this string into inbuff at location of '&'
			inbuff.replace(inbuff.rfind(CONT_CHAR),linbuff.length(),linbuff);
			cont = false;
		} else {
			inbuff = linbuff;
		}
		// -- search for continuation character '&' if found
		if (inbuff.length() > 0 && inbuff.at(inbuff.length()-1) == CONT_CHAR) {
			// -- continuation
			cont = true;
		}
		if (!cont || file.eof()){
			SourceLine SourceLine;
			SourceLine.source_line_no = line_no;
			SourceLine.line_no        = global_line_no;
			SourceLine.filename       = fname;
			SourceLine.text           = inbuff;
			// cout << SourceLine << endl;
			SL.push_back(SourceLine);
		}
		line_no++;
		global_line_no++;
	}
	file.close();
	return true;
}

void include_file(const string& fname, _itGLESource igs, _GLESource &gle_txt) {
	_GLESource temp;
	text_load_include(fname, temp);
	printf("-{%s}",fname.c_str());
	gle_txt.insert(igs,temp.begin(),temp.end());
	igs++;
}

//
// -- directory finding routines
//

void FillIncludePaths(vector<string> &IP)
{
	// fills containor with paths to search for
	// file.  This is called if it can't find file
	// in current directory
	//
	//  Paths searched are:
	// %GLE_TOP%
	// %GLE_TOP%/lib
	// %GLE_USRLIB%
	//  note that GLE_USERLIB can contain multiple
	// directories separated by ; (PC) or : (unix)
	// as defined in PATH_SEP
	//
	//printf("string paths for GLE_PATH\n");
	string paths = GLE_TOP_DIR + DIR_SEP + "lib";
	IP.push_back(paths);
	//printf("paths for GLE_USRLIB\n");
  	const char* usr_lib = getenv("GLE_USRLIB");
	if (usr_lib != NULL) {
		paths = getenv("GLE_USRLIB");
		// spilt on path sep ; for pc : for unix
		//printf("typedef boost::tokenizer ...\n");
		typedef tokenizer<char_separator> Tok;
		//printf("boost:: char_separator ...\n");
		char_separator sep(PATH_SEP.c_str());
		Tok tok(paths, sep);
		//printf("for(Tok::iterator ...\n");
		while (tok.has_more()) {
			IP.push_back(tok.next_token());
		}
	}
}

// Get extension of filename and convert it to lower case
void GetExtension(const string& fname, string& ext) {
	string::size_type i = fname.rfind('.');
	if (i != string::npos) {
		ext = fname.substr(i+1);
		string::size_type len = ext.length();
		for (i = 0; i < len; i++) {
			int ch = ext.at(i);
			if (ch >= 'A' && ch <= 'Z') {
				ch += 'a' - 'A';
				ext.at(i) = ch;
			}
		}
	} else {
		ext = "";
	}
}

// Get file name without extension
void GetMainName(const string& fname, string& name) {
	string::size_type i = fname.rfind('.');
	if (i != string::npos) {
		name = fname.substr(0, i);
	} else {
		name = fname;
	}
}

// Get path of file name (assume last part after DIR_SEP is file name)
void GetDirName(const string& fname, string& dir) {
	string::size_type i = fname.rfind(DIR_SEP);
	if (i != string::npos) {
		dir = fname.substr(0, i+1);
	} else {
		dir = "";
	}
}

// Split file name in path (dir) and file name (name)
void SplitFileName(const string& fname, string& dir, string& name) {
	string::size_type i = fname.rfind(DIR_SEP);
	if (i != string::npos) {
		dir = fname.substr(0, i+1);
		name = fname.substr(i+1);
	} else {
		name = fname;
		dir = "";
	}
}

void StripPathComponents(string* fname, int nb) {
	while (nb > 0) {
		string::size_type i = fname->rfind(DIR_SEP);
		if (i != string::npos) {
			*fname = fname->substr(0, i);
		} else {
			break;
		}
		nb--;
	}
}

bool GLEMoveFile(const string& from, const string& to) {
#ifdef __WIN32__
#else
	if (rename(from.c_str(), to.c_str()) == -1) return false;
#endif
	return true;
}

bool GLECopyFile(const string& from, const string& to) {
	ofstream out(to.c_str());
	ifstream strm(from.c_str());
	while (!strm.eof()) {
		char ch;
		strm.read(&ch, 1);
		out << ch;
	}
	out.close();
	strm.close();
	return true;
}

// Return current directory
bool GLEGetCrDir(string* name) {
#ifdef __WIN32__
	TCHAR buffer[1024];
	if (GetCurrentDirectory(1024, buffer) != 0) {
		*name = buffer;
		return true;
	} else {
		return false;
	}
#else
	char buffer[1024];
	if (getcwd(buffer, 1024) == NULL) {
		return false;
	} else {
		*name = buffer;
		return true;
	}
#endif
}

// Change directory
bool GLEChDir(const string& dir) {
#ifdef __WIN32__
	return SetCurrentDirectory(dir.c_str());
#else
	return chdir(dir.c_str()) == 0;
#endif
}

int GLESystem(const string& cmd) {
#ifdef __WIN32__
	vector<string> args;
	// Split command line arguments
	level_char_separator separator(" ", "", "\"", "\"");
	tokenizer<level_char_separator> tokens(cmd, separator);
	while (tokens.has_more()) {
		args.push_back(tokens.next_token());
	}
	// Create pointer array
	char **argv = new char*[args.size()+1];
	for (int i = 0; i < args.size(); i++) {
		argv[i] = (char*)args[i].c_str();
	}
	argv[args.size()] = NULL;
	// Command without quotes
	string cmd_arg = args[0];
	str_remove_quote(cmd_arg);
	// Run sub-process
	_flushall();
	intptr_t result = _spawnvp(_P_WAIT, cmd_arg.c_str(), argv);
	// Clean up
	delete[] argv;
	if (result == -1) return GLE_SYSTEM_ERROR;
#else
	system(cmd.c_str());
#endif
	return GLE_SYSTEM_OK;
}

bool GLEFileExists(const string& fname) {
	FILE* f = fopen(fname.c_str(), "rb");
	if (f != NULL) {
		fclose(f);
		return true;
	} else {
		return false;
	}
}

// Create new directory
void MakeDirectory(const string& dir) {
	/* Create directory user read/write/exec, group & others read/exec */
#ifdef __WIN32__
	SECURITY_ATTRIBUTES sec_attr;
	sec_attr.nLength = sizeof(SECURITY_ATTRIBUTES);
	sec_attr.lpSecurityDescriptor = NULL;
	sec_attr.bInheritHandle = FALSE;
	CreateDirectory(dir.c_str(), &sec_attr);
#else
	mkdir(dir.c_str(), S_IRWXU | S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH);
#endif
}

// Recursively create directory if it does not yet exist
void EnsureMkDir(const string& dir) {
	if (!IsDirectory(dir)) {
		int done = 0;
		string temp = dir;
		vector<string> comps;
		do {
			string::size_type i = temp.rfind(DIR_SEP);
			if (i != string::npos) {
				comps.push_back(temp.substr(i+1));
				temp = temp.substr(0, i);
			} else {
				comps.push_back(temp);
				done = 1;
			}
		} while (done == 0 && (!IsDirectory(temp)));
		if (done == 0) {
			temp += DIR_SEP;
		} else {
			temp = "";
		}
		for (int i = comps.size()-1; i >= 0; i--) {
			temp += comps[i];
			MakeDirectory(temp);
			if (i > 0) temp += DIR_SEP;
		}
	}
}

// Delete file with extension replaced by given one
bool TryDeleteFile(const string& fname) {
#ifdef __WIN32__
	DeleteFile(fname.c_str());
#else
	unlink(fname.c_str());
#endif
	return true;
}

// Delete file with extension replaced by given one
bool DeleteFileWithExt(const string& fname, const char* ext) {
	string main_name;
	GetMainName(fname, main_name);
	main_name += ext;
	return TryDeleteFile(main_name);
}

// Read line from file
int ReadFileLine(istream& file, string& line) {
    line = "";
    int count = 0;
    char ch = '\n';
    while ((ch == '\n' || ch == '\r') && !file.eof()) {
        file.read(&ch, 1);
    }
    while (ch != '\n' && ch != '\r' && !file.eof()) {
        count++;
        line += ch;
        file.read(&ch, 1);
    }
    return count;
}

int ReadFileLineAllowEmpty(istream& file, string& line) {
    line = "";
    char ch;
    int count = 0;
    file.read(&ch, 1);
    while (ch != '\n' && ch != '\r' && !file.eof()) {
        count++;
        line += ch;
        file.read(&ch, 1);
    }
    return count;
}

bool IsDirectory(const string& fname) {
#if defined(__UNIX__) || ( defined(__OS2__) && defined(__EMX__) )
	struct stat stat_buf;
	if (stat((const char *)fname.c_str(), &stat_buf) == 0) {
		return S_ISDIR(stat_buf.st_mode);
	} else {
		return false;
	}
#else
	struct _stat stat_buf;
	if (_stat((const char *)fname.c_str(), &stat_buf) == 0) {
		return (stat_buf.st_mode & _S_IFDIR);
	} else {
		return false;
	}
#endif
}

void GLEFindFiles(const string& dir, const vector<string>& tofind, vector<string*>& result) {
	static int find_files_progress = 0;
	vector<string> subdirs;
	if (find_files_progress++ == 10) {
		cout << "."; fflush(stdout);
		find_files_progress = 0;
	}
#ifdef __WIN32__
	WIN32_FIND_DATA FindFileData;
	string findpattern = dir + DIR_SEP + "*.*";
	HANDLE hFind = FindFirstFile(findpattern.c_str(), &FindFileData);
	if (hFind == INVALID_HANDLE_VALUE) {
		return;
	}
	do {
		const char* name = FindFileData.cFileName;
		if ((FindFileData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) != 0) {
			if (!str_i_equals(name, ".") && !str_i_equals(name, "..")) {
				subdirs.push_back(name);
			}
		} else {
			for (int i = 0; i < tofind.size(); i++) {
				if (str_i_equals(name, tofind[i].c_str())) {
					(*result[i]) = dir + DIR_SEP + tofind[i];
				}
			}
		}
	} while (FindNextFile(hFind, &FindFileData) != 0);
	FindClose(hFind);
#endif
	for (int i = 0; i < subdirs.size(); i++) {
		string nextdir = dir + DIR_SEP + subdirs[i];
		GLEFindFiles(nextdir, tofind, result);
	}
}

string GetActualFilename(string fname)
{
	// will return the filename
	// if found in ./ or in any of the include
	// paths, will return empty string if
	// file not found

	std::ifstream file;
	file.open(fname.c_str());
	if (file.is_open()){
		file.close();
		return fname;
	}

	// -- try the IncludePaths
	vector<string> IncludePaths;
	FillIncludePaths(IncludePaths);
	vector<string>::iterator vsi = IncludePaths.begin();
	while(vsi != IncludePaths.end()){
		string p = *vsi+DIR_SEP.c_str()+fname;
		file.open(p.c_str());
		if(file.is_open()){
			file.close();
			return p;
		}
		vsi++;
	}
	return "";
}

StreamTokenizerMax::StreamTokenizerMax(const string& fname, int sep, int max) : m_File(fname.c_str()) {
	m_Sep = sep; m_Max = max; m_IsOK = 1;
	m_LastToken = new char[m_Max+1];
	if (!m_File.is_open()) {
		m_IsOK = 0;
	}
}

StreamTokenizerMax::~StreamTokenizerMax() {
	delete[] m_LastToken;
}

bool StreamTokenizerMax::hasMoreTokens() {
	if (m_IsOK == 1) readNextToken();
	return m_IsOK == 1;
}

const char* StreamTokenizerMax::nextToken() {
	return m_LastToken;
}

void StreamTokenizerMax::close() {
	m_File.close();
}

bool StreamTokenizerMax::isSepChar(char ch) {
	return ch == m_Sep || ch == '\n' || ch == '\r' || ch == 0;
}

void StreamTokenizerMax::readNextToken() {
	char ch = m_Sep;
	while (isSepChar(ch) && !m_File.eof()) {
		m_File.read(&ch, 1);
	}
	int count = 0;
	while (count < m_Max && !isSepChar(ch) && !m_File.eof()) {
		if (ch != m_Sep) m_LastToken[count++] = ch;
		m_File.read(&ch, 1);
	}
	m_LastToken[count] = 0;
	while (!isSepChar(ch) && !m_File.eof()) {
		m_File.read(&ch, 1);
	}
	if (m_File.eof()) {
		m_IsOK = 0;
	}
}

//
// -- the only two dir finding routines needed
//
const int PATH_LENGTH = 256;

void CopyGLETop(char* buf) {
	strcpy(buf, GLE_TOP_DIR.c_str());
}

char *fontdir(char *fname)
{
	// simply returns %GLE_TOP%/font
	static char fbuff[PATH_LENGTH];
	CopyGLETop(fbuff);
	strcat(fbuff,DIR_SEP.c_str());
	strcat(fbuff,"font");
	strcat(fbuff,DIR_SEP.c_str());
	strcat(fbuff,fname);
	return fbuff;
}

char *gledir(char *fname)
{
	// simply returns %GLE_TOP%
	static char fbuff[PATH_LENGTH];
	CopyGLETop(fbuff);
	strcat(fbuff,DIR_SEP.c_str());
	strcat(fbuff,fname);
	return fbuff;
}

//
// -- are any of these needed ???????????????
//
char errgle[90];
int dont_clear;

void gle_abort(char *s)
{
	printf("%s",s);
    exit(1);
}


void fner(char *s)
{
	if (dont_clear) return;
	printf("%s\n",s);
	return;
}

void int_edt(char *fname)
{
}

void scr_end()
{
}

void scr_refresh()
{
}

void delay(int)
{
}

void text_inkey()
{
}

void abort_key()
{
}

