#ifndef INCLUDE_FILE_IO
#define INCLUDE_FILE_IO

char *fontdir(char *fname);
char *line(int i);
void abort_key();
void delay(int);
void FillIncludePaths(std::vector<std::string> &IP);
void fner(char *s);
void gle_abort(char *s);
void int_edt(char *fname);
void scr_end();
void scr_refresh();
void text_inkey();
bool text_load_include(const string& fname, _GLESource &SL, int global_line_no = 1);
bool text_load(const string& fname, _GLESource &SL, int global_line_no = 1);
bool text_load(const string& fullname, const string& fname, _GLESource &SL, int global_line_no = 1);
void include_file(const string& fname, _itGLESource igs, _GLESource &gle_txt);

void GetExtension(const string& fname, string& ext);
void GetMainName(const string& fname, string& name);
void SplitFileName(const string& fname, string& dir, string& name);
void GetDirName(const string& fname, string& dir);
void EnsureMkDir(const string& dir);
bool TryDeleteFile(const string& fname);
bool DeleteFileWithExt(const string& fname, const char* ext);
int ReadFileLine(istream& file, string& line);
int ReadFileLineAllowEmpty(istream& file, string& line);
bool IsDirectory(const string& fname);
bool GLEMoveFile(const string& from, const string& to);
bool GLECopyFile(const string& from, const string& to);
bool GLEGetCrDir(string* name);
bool GLEChDir(const string& dir);
void GLEFindFiles(const string& dir, const vector<string>& tofind, vector<string*>& result);
int GLESystem(const string& cmd);
bool GLEFileExists(const string& fname);
void StripPathComponents(string* fname, int nb);

#define GLE_SYSTEM_OK    0
#define GLE_SYSTEM_ERROR 1

class StreamTokenizerMax {
protected:
	char* m_LastToken;
	int m_Sep, m_Max, m_IsOK;
	ifstream m_File;
public:
	StreamTokenizerMax(const string& fname, int sep, int max);
	~StreamTokenizerMax();
	bool hasMoreTokens();
	bool isSepChar(char ch);
	const char* nextToken();
	void readNextToken();
	void close();
	inline ifstream& getFile() { return m_File; }
};

#endif
