
#include <math.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <assert.h>
#include <string>
#include <sstream>
#include <iostream>
#include <vector>
#include <list>
#include <map>
#include <fstream>
using namespace std;
#include "SourceLine.h"
#include "file_io.h"
typedef double dbl;

//#ifndef unix
#include <stdarg.h>
//#endif
#include "all.h"
#include "tokens/Tokenizer.h"
#include "mygraph.h"
#include "gprint.h"
#include "cutils.h"
char *line(int i);
#define false 0
#define true (!false)

int this_line;
int g_error_col = -1;
int last_line = -1;
extern int trace_on;
bool new_error = true;
extern int ngerror;
extern 	_GLESource GLESource;
void gprint_send(const char* ss);
void gprint_send(const string& output);
void check_new_error();

#ifdef __UNIX__
	void gprint(const char* arg_list, ...)
#else
	void gprint(va_list arg_list, ...)
#endif
/* Prints an error message */
{
	va_list arg_ptr;
	char *format;
	char output[1024];
	int len;
	va_start(arg_ptr, arg_list);
	format = (char*)arg_list;
	vsprintf(output, format, arg_ptr);
	output[1023] = 0;
	check_new_error();
	gprint_send(output);
	g_set_error_column(-1);
}

void gprint(const string& output) {
	check_new_error();
	gprint_send(output);
	g_set_error_column(-1);
}

void check_new_error() {
	if (new_error) {
		ngerror++;
		if (last_line != this_line && !trace_on) {
			stringstream ss;
			_itGLESource itg = GLESource.begin();
			advance(itg,this_line-1);
			ss << endl << ">> " << *itg;
			if (g_error_col != -1) {
				ss << ">> ";
				itg->showPosPointer(g_error_col, ss);
			}
			gprint_send(ss.str().c_str());			
		}
		last_line = this_line;
		new_error = false;
	}
}

void gprint_send(const char *ss) {
	string output = ss;
	gprint_send(output);
}

/* No new error if does not end in \n */
void gprint_send(const string& output) {
	string strg = output;
	string::size_type pos = strg.find('\n');
	while (pos != string::npos) {
		string part = strg.substr(0, pos);
		g_message((char*)part.c_str());
		string::size_type len = strg.length();
		strg = strg.substr(pos+1, len-pos);
		pos = strg.find('\n');
	}
	if (gle_onlyspace(strg)) {
		new_error = true;
	} else {
		g_message((char*)strg.c_str());
	}
}

void reset_new_error(bool val) {
	new_error = val;
}

int get_nb_errors() {
	return ngerror;
}

void inc_nb_errors() {
	ngerror++;
}

void g_set_error_column(int col) {
	g_error_col = col;
}

void g_set_error_line(int lin) {
	this_line = lin;
}
