//
// graph include
//

#ifdef VAXC 		/* because it won't fit on the PC */
#define HERROR 1		/* because it won't fit on the PC */
#endif
#define HERROR 1 /* only uses about 2k more */

#define BEGINDEF extern

#define GLE_GRAPH_LM_PLAIN    0
#define GLE_GRAPH_LM_STEPS    1
#define GLE_GRAPH_LM_FSTEPS   2
#define GLE_GRAPH_LM_HIST     3
#define GLE_GRAPH_LM_IMPULSES 4

/* for key command and gx(), gy() */

#define dbg if ((gle_debug & 64)>0)
#define LARGE_NUM 1E30
extern int gle_debug;

void graph_init(void);
void graph_free(void);
void iffree(void *p,char *s);
void setrange(double x, double y, int m);
void gdraw_key(offset_struct koffset, char *kpos, double khei, int knobox);
void copy_default(int d);
void do_dataset(int d);
void draw_errbar(double x, double y, double eup, double ewid);
void fill_vec(double x1, double y1, double x2, double y2);
void do_smooth(void);
void window_set(void);
bool window_min_max_set();
void draw_bars(void);
void draw_lines(void);
void draw_fills(void);
void draw_err(void);
void do_let(char *s, bool finetune);
void request(void);
/*int draw_axis(void *axis);*/
void draw_bar(double x, double yf, double yt, double wd,double x3d,double y3d,int sidecolor, int topcolor, int notop);
void doskip(char *s,int *ct);
double get_next_exp(TOKENS tk,int ntk,int *curtok);
void store_window_bounds_to_vars();
void draw_markers(void) throw (ParserError);
void draw_mark(double x1, double y1, int i, double sz, double dval) throw (ParserError);

/* #define fnx(vv)  (((vv-wxmin)/(wxmax-wxmin)) * xlength + xbl) */
/* #define fny(vv)  (((vv-wymin)/(wymax-wymin)) * ylength + ybl) */
#define kw(ss) if (str_i_equals(tk[ct],ss))
#define true (!false)
#define false 0

void var_find_dn(int *idx, int *vara, int *nd);
char *un_quote(char *ct);

#define skipspace doskip(tk[ct],&ct)
//#define tok(n)  (*tk)[n]
#define tok(n)  tk[n]
#define next_exp (get_next_exp(tk,ntk,&ct))
#define next_font ((ct+=1),pass_font(tk[ct]))
#define next_marker ((ct+=1),pass_marker(tk[ct]))
#define next_color ((ct+=1),pass_color_var(tk[ct]))
#define next_fill ((ct+=1),pass_color_var(tk[ct]))
#define next_str(s)  (ct+=1,skipspace,strcpy(s,tk[ct]))
#define next_str_cpp(s)  (ct+=1,skipspace,s=tk[ct])
#define next_vstr(s)  (ct+=1,skipspace,mystrcpy(&s,tk[ct]))
#define next_vquote(s) (ct+=1,skipspace,mystrcpy(&s,un_quote(tk[ct])))
#define next_vquote_cpp(s) (ct+=1,skipspace,s = un_quote(tk[ct]))
#define next_quote(s) (ct+=1,skipspace,strcpy(s,un_quote(tk[ct])))
#define ifer if (erflg)


struct fill_data {
	int da,db;	/* fill from, too */
	int type; 	/* 1= x1,d1, 2=d1,x2, 3=d1,d2, 4=d1 */
	int color;
	double xmin,ymin,xmax,ymax;
};
struct data_struct 
{
	double *xv;	/* x data values */
	double *yv; /* y data values */
	int *miss; /* if true miss this point */
	int nomiss; 
	int np, /* NUMBER OF POINTS */
		autoscale;
	char lstyle[9];
	char *bigfile;	/* for datasets too big for memory */
	char *key_name;
	int key_fill;
	char errup[9],errdown[9];
	double errwidth;
#ifdef HERROR 		/* because it won't fit on the PC */
	char herrup[9],herrdown[9];
	double herrwidth;
#endif
	double msize,lwidth;
	int 
	marker, 
	smooth, 
	smoothm, 
	svg_smooth, /* Savitski Golay filtering true=on */
	svg_poly,  /* the type of polynomial 2,3,4,5...*/
	svg_points, /* the number of points 5,7,9,11.... */
	svg_iter; /* numb or time to do svg smoothing */
	int line_mode;
	int mdata;
	int color;
	double scale_ax, scale_bx, scale_ay, scale_by;
	double xmin,ymin,xmax,ymax;
	double mscale;
	int line;
	double rx1,ry1,rx2,ry2;
};
struct bar_struct {
	int ngrp;
	int from[20];
	int to[20];
	double width,dist;
	double lwidth[20];
	char lstyle[20][9];
	int fill[20];
	int color[20];
	int side[20];
	int top[20];
	int notop;
	double x3d,y3d;
};

#ifdef __TURBOC__
#define MAXTEMP 2000
#else
#define MAXTEMP 10000
#endif

#ifdef GRAPHDEF
#else
#define GRAPHDEF
#endif

GRAPHDEF double range_x1,range_y1,range_x2,range_y2;  /* graph unist */
GRAPHDEF double graph_x1,graph_y1,graph_x2,graph_y2;  /* in cm */
GRAPHDEF double graph_xmin,graph_ymin,graph_xmax,graph_ymax; /* graph units */
GRAPHDEF double *tmpf;  /* [MAXTEMP+10]; */
GRAPHDEF int *tmpmiss; /*  [MAXTEMP+10]; */
GRAPHDEF int ntmp_alloc; /*  [MAXTEMP+10]; */
GRAPHDEF char ebuff[400];
GRAPHDEF int etype,eplen;
GRAPHDEF double wxmin,wymin,wxmax,wymax; /* in axis units the bounds of the graph */
GRAPHDEF double xbl,ybl;
GRAPHDEF double xlength,ylength;
GRAPHDEF double g_xsize,g_ysize,g_hscale,g_vscale,g_fontsz;
GRAPHDEF double last_vecx,last_vecy;
GRAPHDEF int ndata,g_nobox,done_line;
GRAPHDEF double sizex,sizey;
GRAPHDEF double vscale,hscale;
/*GRAPHDEF int g_ynegate; */
GRAPHDEF int data_negate[3];		/* a.r. */

GRAPHDEF struct fill_data *fd[20];
GRAPHDEF int nfd;
GRAPHDEF int gntmp;

GRAPHDEF struct data_struct *dp[101];
GRAPHDEF struct data_struct *dpp;

GRAPHDEF int g_nbar;
GRAPHDEF struct bar_struct *br[20];
void vinit_axis(int i);

#define DP_CAST (struct data_struct*)
#define BR_CAST (struct bar_struct*)
#define AX_CAST (axis_struct*)
#define FD_CAST (struct fill_data*)

