
#include <math.h>
#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string>
#include <vector>
#include <list>
using namespace std;

#include "tokens/Tokenizer.h"
#include "SourceLine.h"
#include "all.h"
#include "mem_limits.h"
#include "token.h"
#include "SourceLine.h"
#include "glearray.h"
#include "polish.h"
#include "pass.h"
#include "key.h"
#include "mygraph.h"
#include "justify.h"
#include "color.h"
#include "core.h"
#include "gprint.h"
#include "cutils.h"

/* for key command and gx(), gy() */
extern double graph_x1,graph_y1,graph_x2,graph_y2;  /* in cm */
extern double graph_xmin,graph_ymin,graph_xmax,graph_ymax; /* graph units */
#define BEGINDEF extern
#include "begin.h"
#include <math.h>
#define dbg if ((gle_debug & 64)>0)
#define LARGE_NUM 1E30
char *un_quote(char *ct);
extern int gle_debug;
void doskip(char *s,int *ct);
double get_next_exp(TOKENS tk,int ntk,int *curtok);
#define kw(ss) if (str_i_equals(tk[ct],ss))
#define true (!false)
#define false 0
#define skipspace doskip(tk[ct],&ct)
#define tok(n)  (*tk)[n]
#define next_exp (get_next_exp(tk,ntk,&ct))
#define next_font ((ct+=1),pass_font(tk[ct]))
#define next_marker ((ct+=1),pass_marker(tk[ct]))
#define next_color ((ct+=1),pass_color_var(tk[ct]))
#define next_fill ((ct+=1),pass_color_var(tk[ct]))
#define next_str(s)  (ct+=1,strcpy(s,tk[ct]))
#define next_vstr(s)  (ct+=1,mystrcpy(&s,tk[ct]))
#define next_vquote(s) (ct+=1,mystrcpy(&s,un_quote(tk[ct])))
#define next_quote(s) (ct+=1,strcpy(&s,un_quote(tk[ct])))

#define ifer if (erflg)

struct key_struct *kd[100];

void begin_key(int *pln, int *pcode, int *cp) {
    int nkd=0;
    double khei=0,zzhei;
    char kpos[34];
    int knobox=0,st;
    int sl,ct,i,ncol,ntmp,np,c,*m,t,d,b;
    int col = 0;
    bool has_error = false;
    struct offset_struct koffset;

    koffset.x = 0.0;
    koffset.y = 0.0;
    koffset.enable = false;
    koffset.absolute = false;

    g_get_hei(&zzhei);

    strcpy(kpos, "BL");
    (*pln)++;
    begin_init();
    for (;;)
	{
		st = begin_token(&pcode,cp,pln,srclin,tk,&ntk,outbuff);
		if (!st)
		{
			/* exit loop */
			break;
		}
		/* line count variable*/
		ct = 1;
		while (ct<=ntk)
		{
			skipspace;
			kw("OFFSET") {
				koffset.x = next_exp;
				koffset.y = next_exp;
				koffset.enable = true;
			}
			else    kw("ABSOLUTE") {
				if (!koffset.enable) {
					gprint("key: 'absolute' should be used in combination with 'offset'");
					has_error = true;
				}
				koffset.absolute = true;
			}
			else	kw("NOBOX") 	knobox = true;
			else 	kw("HEI")	khei = next_exp;
			else 	kw("POSITION")	next_str(kpos);
			else 	kw("POS")	next_str(kpos);
			else 	kw("SEPARATOR")	{
				if (nkd == 0) {
					gprint("key: 'separator' should come after a valid key entry");
					has_error = true;				
				} else {
					ct++;
					kw("LSTYLE") {
						kd[nkd]->sepstyle = (int)floor(next_exp + 0.5);
					} else {
						ct--;
					}
					col++;
				}
			}
			else 	kw("JUSTIFY")	next_str(kpos);
			else {
				if (ct==1)
				{
					nkd++;
					kd[nkd] = (struct key_struct*) myallocz(sizeof(*kd[1]));
					kd[nkd]->column = col;
					kd[nkd]->sepstyle = -1;
				}
				if (nkd==0) return;

				kw("TEXT")  		next_vquote(kd[nkd]->descrip);
				else kw("MARKER")  	{kd[nkd]->marker = next_marker;
			}
			else 	kw("MSIZE")		kd[nkd]->msize = next_exp;
			else 	kw("MSCALE")	kd[nkd]->msize = (next_exp) * zzhei;
			else 	kw("COLOR") 	kd[nkd]->color = next_color;
			else 	kw("FILL") 	kd[nkd]->fill = next_fill;
			else 	kw("LSTYLE") 	next_str(kd[nkd]->lstyle);
			else 	kw("LINE") 	strcpy(kd[nkd]->lstyle,"1");
			else 	kw("LWIDTH") 	kd[nkd]->lwidth = next_exp;
			else	gprint("Unrecognised KEY sub command {%s} %d \n ",tk[ct],ct);
			}/* end if*/
			ct++;
		}/* end while*/
    }/*end for*/
    if (!has_error) {
	draw_key(nkd,&koffset,kpos,khei,knobox);
    }
}

class ColInfo {
public:
	double width;
	double offsx;
	int nrows;
public:
	ColInfo();
	ColInfo(const ColInfo& other);
};

ColInfo::ColInfo() {
	width = 0.0;
	offsx = 0.0;
	nrows = 0;
}

ColInfo::ColInfo(const ColInfo& other) {
	width = other.width;
	offsx = other.offsx;
	nrows = other.nrows;
}

void draw_key(int nkd, struct offset_struct* koffset, char *kpos,double khei, int knobox)
{
	int kl=0,km=0,kf=0;
	int i;
	int old_color;
	double cx,cy,z;
	double ox,oy,bl,br,bu,bd,savex,savey;
	double sx=0,sy=0;
	double cr,savelw,midx,midy;
	vector<ColInfo> colinfo;
	/* Initialize */
	g_get_xy(&savex,&savey);
	if (nkd==0) return;
	if (khei==0) g_get_hei(&khei);
	cr = 1.2*khei;
	/* Set booleans: kl = lstyle, km = marker, kf = fill */
	for (i=nkd;i>=1;i--) {
		if (kd[i]->lstyle[0]==0) if (kd[i]->lwidth>0) kd[i]->lstyle[0]='1';
		if (kd[i]->lstyle[0]!=0) kl = true;
		if (kd[i]->lwidth>0) kl = true;
		if (kd[i]->marker!=0) km = true;
		if (kd[i]->fill!=0) kf = true;
	}
	/* Measure all labels and count rows in each column */
	g_set_hei(khei);
	for (i = 1; i <= nkd; i++) {
		int col = kd[i]->column;
		if (colinfo.size() <= col) colinfo.push_back(ColInfo());
		if (kd[i]->descrip!=NULL) {
			g_measure(kd[i]->descrip,&bl,&br,&bu,&bd);
			if (colinfo[col].width < br) colinfo[col].width = br;
		}
		colinfo[col].nrows++;
	}
	/* Compute size for marker, line and fill */
	double entry_wd = 0.0;
	if (kl) entry_wd += 2*cr;
	if (km) entry_wd += 1.5*cr;
	if (kf) entry_wd += 1.3*cr;
	/* Compute sum of column widths and max number of rows */
	int maxrow = 0;
	double sumwid = 0.0;
	for (i = 0; i < colinfo.size(); i++) {
		sumwid += colinfo[i].width;
		if (colinfo[i].nrows > maxrow) maxrow = colinfo[i].nrows;
	}
	/* Initialize offsets for each column */
	colinfo[0].offsx = 0.0;
	for (i = 1; i < colinfo.size(); i++) {
		colinfo[i].offsx = colinfo[i-1].offsx + colinfo[i-1].width + entry_wd + 1*cr;
	}
	sx = sumwid + entry_wd*colinfo.size();
	sx = sx + 1.2*cr + 1*cr*(colinfo.size()-1);
	sy = maxrow*cr + 1.2*cr-.3*khei;
	if (!koffset->enable) {
		/* Relative to graph */
		midx = graph_x1 + (graph_x2-graph_x1)/2;
		midy = graph_y1 + (graph_y2-graph_y1)/2;
		if (str_i_equals(kpos,"TL")) {ox = graph_x1;oy = graph_y2-sy;}
		else if (str_i_equals(kpos,"BL")) {ox = graph_x1; oy = graph_y1;}
		else if (str_i_equals(kpos,"BR")) {ox = graph_x2-sx;oy = graph_y1;}
		else if (str_i_equals(kpos,"TR")) {ox = graph_x2-sx; oy = graph_y2-sy;}
		else if (str_i_equals(kpos,"TC")) {ox = midx-sx/2; oy = graph_y2-sy;}
		else if (str_i_equals(kpos,"BC")) {ox = midx-sx/2; oy = graph_y1;}
		else if (str_i_equals(kpos,"RC")) {ox = graph_x2-sx; oy = midy-sy/2;}
		else if (str_i_equals(kpos,"LC")) {ox = graph_x1; oy = midy-sy/2;}
		else if (str_i_equals(kpos,"CC")) {ox = midx-sx/2; oy = midy-sy/2;}
		else {
			if (strlen(kpos)>0) gprint("Expecting POS BL,BR,TR or TL\n");
			ox = graph_x2-sx; oy = graph_y2-sy;
		}
	} else {
		ox = koffset->x;
		oy = koffset->y;
		if (!koffset->absolute) {
			double px, py;
			g_get_xy(&px, &py);
			ox += px; oy += py;
		}
		/* Support different relative positions for offset command */
		if (str_i_equals(kpos,"TL")) {oy -= sy;}
		else if (str_i_equals(kpos,"BR")) {ox -= sx; }
		else if (str_i_equals(kpos,"TR")) {ox -= sx; oy -= sy;}
		else if (str_i_equals(kpos,"TC")) {ox -= sx/2; oy -= sy;}
		else if (str_i_equals(kpos,"BC")) {ox -= sx/2;}
		else if (str_i_equals(kpos,"RC")) {ox -= sx; oy -= sy/2;}
		else if (str_i_equals(kpos,"LC")) {oy -= sy/2;}
		else if (str_i_equals(kpos,"CC")) {ox -= sx/2; oy -= sy/2;}
	}
	g_get_color(&old_color);
	g_set_fill(COLOR_WHITE);
	if (!knobox) g_box_fill(ox,oy,ox+sx,oy+sy);
	/* Draw all labels */
	int row = 0;
	int prev_col = 0;
	g_set_color(old_color);
	for (i = 1; i <= nkd; i++) {
		if (prev_col != kd[i]->column) {
			row = 0;
			prev_col = kd[i]->column;
			if (i > 1 && kd[i-1]->sepstyle != -1) {
				char msep[9];
				// should implement g_set_line_style that takes int
				sprintf(msep, "%d", kd[i-1]->sepstyle);
				g_set_line_style(msep);
				g_move(ox+.3*cr+colinfo[prev_col].offsx, oy);
				g_line(ox+.3*cr+colinfo[prev_col].offsx, oy+sy);		
				g_set_line_style("1");	
			}
		}
		g_move(ox+.6*cr+colinfo[prev_col].offsx,oy+.6*cr+cr*(maxrow-row-1));
		g_get_xy(&cx,&cy);
		if (kd[i]->color!=0) g_set_color(kd[i]->color);
		if (km) {
			g_rmove(cr/2,khei*.35);
			z = kd[i]->msize;
			if (z==0) z = khei;
			if (kd[i]->marker!=0) g_marker(kd[i]->marker,z);
			g_rmove(cr,-khei*.35);
		}
		if (kl) {
			g_set_line_style(kd[i]->lstyle);
			g_get_line_width(&savelw);
			g_set_line_width(kd[i]->lwidth);
			g_rmove(0.0,cr*.3);
			if (kd[i]->lstyle[0]==0) g_rmove(1.5*cr,0.0);
			else g_rline(1.5*cr,0.0);
			g_rmove(cr/2,-cr*.3);
			g_set_line_style("1");
			g_set_line_width(savelw);
		}
		if (kf) {
			if (kd[i]->fill!=0) {
				g_set_fill(kd[i]->fill);
				g_get_xy(&cx,&cy);
				g_box_fill(cx,cy,cx+cr*.7,cy+cr*.66);
				g_box_stroke(cx,cy,cx+cr*.7,cy+cr*.66);
			}
			g_rmove(1.3*cr,0.0);
		}
		g_get_xy(&cx,&cy);
		if (kd[i]->color!=0) g_set_color(old_color);
		g_set_just(JUST_LEFT);
		if (kd[i]->descrip!=NULL) g_text(kd[i]->descrip);
		row++;
	}
	if (!knobox) g_box_stroke(ox,oy,ox+sx,oy+sy);
	g_move(savex,savey);
}

