#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <vector>
#include <string>
#include <vector>
#include <list>
using namespace std;
#include "leastsq.h"


void least_square(vector<double>* x,vector<double>* y,double* slope, double* offset, double* rsquared)
{
	//
	// does a least squares fit to the data x and y which have n elements
	// x,y.... the values
	// n the size of the x and y arrays
	// slope... the tresulting slope
	// offset.. the resulting offset
	// rsquared.. the goodness of fit 1=ideal 0 = poor
	//
	double 
	sum_x=0, 
	sum_y=0,
    sum_xy=0, 
	sum_xx=0,
    delta=0;

	register int i,n;
	n=x->size();
	for (i=0;i<n;i++)
	{
//	printf("x[%d]=%0.6f y[%d]=%0.6f\n",i,(*x)[i],i,(*y)[i]);
		sum_x += (*x)[i];
		sum_y += (*y)[i];
		sum_xy += (*x)[i]*(*y)[i];
		sum_xx += (*x)[i]*(*x)[i];
	}

	delta = n*sum_xx - sum_x*sum_x;
	*slope = (n*sum_xy - sum_x*sum_y)/delta;
	*offset = (sum_xx*sum_y - sum_x*sum_xy)/delta;
	//
	// compute rsquared
	//
	for (i=0;i<n;i++)
	{
		*rsquared += pow((*y)[i] - (*slope) * (*x)[i] - *offset,2);
	}
	*rsquared = 1 - *rsquared;
}
