/*
 * 2004 Jan Struyf
 * Separator for the boost tokenizer that kan jump over expressions between
 * certain delimiters.
 */

#if !defined(BOOST_MSVC) || BOOST_MSVC > 1300
template <typename Char,
	typename Traits = typename std::basic_string<Char>::traits_type >
#else
template <typename Char,
	typename Traits = std::basic_string<Char>::traits_type >
#endif
class level_char_separator {
	typedef std::basic_string<Char,Traits> string_type;
public:

	explicit level_char_separator(const Char* dropped_delims,
	                              const Char* kept_delims,
				      const Char* level_up,
				      const Char* level_down)
	        : m_dropped_delims(dropped_delims),
		  m_kept_delims(kept_delims),
		  m_level_up_delims(level_up),
		  m_level_down_delims(level_down) {
	}

	void reset() {
	}

	template <typename InputIterator, typename Token>
	bool operator()(InputIterator& next, InputIterator end, Token& tok) {
		tok = Token();
		while (next != end && is_dropped(*next)) {
			++next;
		}
		if (next == end) return false;
		if (is_kept(*next)) {
			tok += *next;
			++next;
		} else {
			// append all the non delim characters
			int level = 0;
			while (next != end) {
				if (level == 0) {
					if (is_dropped(*next) || is_kept(*next)) break;
					if (is_level_up(*next)) level++;
					tok += *next;
				} else {
					if (is_level_down(*next)) level--;
					else if (is_level_up(*next)) level++;
					tok += *next;
				}
				++next;
			}
		}
		return true;
	}

private:
	string_type m_kept_delims;
	string_type m_dropped_delims;
	string_type m_level_up_delims;
	string_type m_level_down_delims;

	bool is_level_up(Char E) const {
		return m_level_up_delims.find(E) != string_type::npos;
	}

	bool is_level_down(Char E) const {
		return m_level_down_delims.find(E) != string_type::npos;
	}

	bool is_kept(Char E) const {
		if (m_kept_delims.length()) {
			return m_kept_delims.find(E) != string_type::npos;
		} else {
			return false;
		}
	}

	bool is_dropped(Char E) const {
		if (m_dropped_delims.length()) {
			return m_dropped_delims.find(E) != string_type::npos;
		} else {
			return false;
		}
	}
};
