
#include <stdlib.h>
#include <list>
#include <string>
#include <vector>
using namespace std;
#include "SourceLine.h"
#include "all.h"
#include "file_io.h"
#include "gprint.h"
#define farcalloc calloc

extern char errgle[];

void free_savemem(void);

char *sdup(char *s)
{
	char *v;
	v = (char*) myalloc(strlen(s)+1);
	strcpy(v,s);
	return v;
}
char *save_memory;
void free_savemem()
{
	if (save_memory!=NULL) free(save_memory);
	save_memory = 0;
}
void init_memory()
{
    save_memory = (char*) malloc(1000);
    if (save_memory == NULL) gle_abort("Not able to allocate save memory\n");
}
static int totalmem,worst;
void myfree(void *p)
{
	myfrees(p,"UNKNOWN");
}
void myfrees(void *p,char *s)
{
	static int *l;


	l = (int *) p;
	totalmem -= *(--l);
	if (*(--l)!=1234) {
		sprintf(errgle,"Free memory (%s) not mine %ld  %ld \n",s,*l,*(++l));
		gle_abort(errgle);
	}
	free(l);
	return;
}
void *myallocn(int nitems,int size)
{
	return myallocz(nitems*size);
}
#define LARGE_SIZE 512*1024 /* 1/2 a megabyte */
void *myalloc(int size)
{
	static void *p;
	static int *l;

	if (size==0) {
		sprintf(errgle," error, attempt to allocate ZERO memory \n");
		gle_abort(errgle);
	}
	if (size>LARGE_SIZE) gprint(" allocating More than %d KB of memory (%d KB) \n",LARGE_SIZE/512,size/1024);
	p = malloc(size+sizeof(int)*2);
	if (p==NULL) {
		freeafont();
		p = malloc(size+sizeof(int)*2);
		if (p==NULL) {
		 free_savemem();
		 sprintf(errgle,"\n Memory allocation failure (size %d)  \n"
			,size);
		 gle_abort(errgle);
		}
	}
	l = (int *) p;
	*l++ = 1234;
	*l = size+sizeof(int)*2;
	totalmem += *l;
	if (totalmem>worst) worst = totalmem;
	p = (void *) ++l;

	return p;
}
void *myallocz(int size)
{
	static void *p;
	static int *l;
	if (size==0) {
		free_savemem();
		sprintf(errgle," zerror, attempt to allocate ZERO memory \n");
		gle_abort(errgle);
	}
	if (size>LARGE_SIZE) gprint(" allocating More than %d KB of memory (%ld KB) \n",LARGE_SIZE/512,size/1024);
/*	if (size>40000) {
	  gprint("(z) allocating a lot of memory %ld \n",size);
	}
	*/
	p = farcalloc(1,size+sizeof(int)*2);
/*	p = farcalloc((size+8)/4,4);*/
	if (p==NULL) {
	   freeafont();
	   p = farcalloc(1,size+sizeof(int)*2);
/* 	   if (p==NULL) {
		free_cache();
		gprint("Freeing cached characters\n");
		p = farcalloc(1,size+sizeof(int)*2);
	   }
*/
	   if (p==NULL) {
		free_savemem();
		sprintf(errgle,"\n\n (z) Memory allocation failure %d  \n\n"
			,size);
		gle_abort(errgle);
	   }
	}
	l = (int *) p;
	*l++ = 1234;
	*l = size+sizeof(int)*2;
	totalmem += *l;
	if (totalmem>worst) worst = totalmem;
	p = (void *) ++l;
	return p;
}
int mem_total()
{
	return totalmem;
}
int mem_worst()
{
	return worst;
}

int gtotalmem;
#ifdef __TURBOC__
#include <alloc.h>
void far * far _graphgetmem(unsigned size)
{
	return(myalloc(size));
}
void far _graphfreemem(void far *ptr, unsigned size)
{
	myfree(ptr);
}

#endif


