
#ifndef NUMBER_FORMAT_H
#define NUMBER_FORMAT_H

class GLENumberFormat;

class GLENumberFormatter {
protected:
	int m_Prefix;
	bool m_NoZeroes;
	bool m_Sign;
	int m_PadLeft;
	int m_PadRight;
	double m_Min;
	double m_Max;
	bool m_HasMin;
	bool m_HasMax;
public:
	GLENumberFormatter();
	virtual ~GLENumberFormatter();
	virtual void parseOptions(GLENumberFormat* format);
	virtual void format(double number, string* output);
	virtual bool appliesTo(double number);
	inline bool hasPrefix() { return m_Prefix != -1; }
	inline int getPrefix() { return m_Prefix; }
	inline void setPrefix(int prefix) { m_Prefix = prefix;  }
	inline bool hasNoZeroes() { return m_NoZeroes; }
	inline void setNoZeroes(bool noz) { m_NoZeroes = noz; }
	inline bool hasSign() { return m_Sign; }
	inline void setSign(bool sign) { m_Sign = sign; }
	void doPrefix(string* output);
	void doNoZeroes(string* output);
	void doSign(string* output);
	void doPadLeft(string* output);
	void doPadRight(string* output);
	void doAll(string* output);
	inline bool hasPadRight() { return m_PadRight != -1; }
	inline int getPadRight() { return m_PadRight; }
	inline void setPadRight(int PadRight) { m_PadRight = PadRight;  }
	inline bool hasPadLeft() { return m_PadLeft != -1; }
	inline int getPadLeft() { return m_PadLeft; }
	inline void setPadLeft(int PadLeft) { m_PadLeft = PadLeft;  }
	void setMin(double min);
	void setMax(double max);
	inline bool hasMax() { return m_HasMax; }
	inline bool hasMin() { return m_HasMin; }
	inline double getMax() { return m_Max; }
	inline double getMin() { return m_Min; }
	void setDefaults(GLENumberFormatter* def);
	void formatSimple(double value, string* output, int prec, int* exp);
};

class GLENumberFormat {
protected:
	char_separator m_Separator;
	tokenizer<char_separator> m_Tokens;
	vector<GLENumberFormatter*> m_Format;
	GLENumberFormatter m_Default;
public:
	GLENumberFormat(const string& format);
	~GLENumberFormat();
	inline bool hasMoreTokens() { return m_Tokens.has_more(); }
	inline const string& nextToken() { return m_Tokens.cr_token(); }
	inline void addFormat(GLENumberFormatter* format)  { m_Format.push_back(format); }
	void format(double number, string* output);
	void incTokens();
	int nextInt();
	double nextDouble();
};

#endif
