#ifndef INCLUDE_PASS
#define INCLUDE_PASS

//typedef struct op_key* OPKEY;
typedef struct op_key OPKEY[];

#define GLE_PARSER_NONE 0
#define GLE_PARSER_INCLUDE 1

class GLEParser {
protected:
	StringTokenizer m_tokens;
	GLEPolish* m_polish;
	string m_include;
	int m_special;
public:
	GLEParser(GLEPolish* polish);
	void initTokenizer();
	void passt(SourceLine &SLine, GLEPcode& pcode) throw(ParserError);
	void polish(GLEPcode& pcode, int *rtype) throw(ParserError);
	void polish(const char* str, GLEPcode& pcode, int *rtype) throw(ParserError);
	void get_var(GLEPcode& pcode) throw (ParserError);
	void get_xy(GLEPcode& pcode) throw(ParserError);
	void get_exp(GLEPcode& pcode) throw(ParserError);
	void get_strexp(GLEPcode& pcode) throw(ParserError);
	int get_anyexp(GLEPcode& pcode) throw(ParserError);
	void get_subroutine_call(string* name, GLEPcode& pcode) throw(ParserError);
	int get_subroutine_def(GLEPcode& pcode) throw(ParserError);
	void get_if(GLEPcode& pcode) throw(ParserError);
	int get_optional(OPKEY lkey, GLEPcode& pcode) throw(ParserError);
	int get_first(OPKEY lkey) throw(ParserError);
	void get_token(const char* token) throw(ParserError);
	bool try_get_token(const char* token) throw(ParserError);
	void get_fill(GLEPcode& pcode) throw (ParserError);
	void get_marker(GLEPcode& pcode) throw (ParserError);
	void get_var_add(int *var, int *vtype) throw (ParserError);
	int pass_marker(const string& marker) throw (ParserError);
	void define_marker_1(GLEPcode& pcode) throw (ParserError);
	void define_marker_2(GLEPcode& pcode) throw (ParserError);
	void get_font(GLEPcode& pcode) throw (ParserError);
	void get_justify(GLEPcode& pcode) throw (ParserError);
	void get_color(GLEPcode& pcode) throw (ParserError);
	void get_join(GLEPcode& pcode) throw (ParserError);
	void get_cap(GLEPcode& pcode) throw (ParserError);
	void get_papersize(GLEPcode& pcode) throw (ParserError);
	void do_text_mode(SourceLine &SLine, Tokenizer* tokens, GLEPcode& pcode) throw (ParserError);
	void checkmode() throw(ParserError);
	void get_block_type(int type, string& result);
	void get_key_info(OPKEY lkey, int* count, int* width);
	ParserError create_option_error(OPKEY lkey, int count, string& token);
	int get_one_option(op_key* lkey, GLEPcode& pcode, int plen) throw(ParserError);
	void duplicate_error(GLEPcode& pcode, int pos) throw(ParserError);
	void checkValidName(const string& name, const char* type, int pos) throw(ParserError);
	void setAllowSpace(bool allow);
	bool not_at_end_command();
	bool test_not_at_end_command();
	inline Tokenizer* getTokens() { return &m_tokens; }
	inline GLEPolish* getPolish() { return m_polish; }
	inline void setString(const char* str) { m_tokens.set_string(str); }
	inline void resetSpecial() { m_special = GLE_PARSER_NONE; }
	inline bool hasSpecial(int special) { return m_special & special != 0; }
	inline void setSpecial(int special) { m_special |= special; }
	inline const string& getInclude() { return m_include; }
	inline void setInclude(const string& name) { m_include = name; }
	inline ParserError error(const string& src) const {
		return m_tokens.error(src);
	};
	inline ParserError error(int column, const string& src) const {
		return m_tokens.error(column, src);
	};
};

int gt_first(OPKEY lkey, int *curtok, TOKENS tk, int *ntok, int *pcode, int *plen);
int gt_firstval(OPKEY lkey,char *s);
int gt_index(OPKEY lkey,char *s);
int gt_optional(OPKEY lkey, int *curtok, TOKENS tk, int *ntok, int *pcode, int *plen);
int pass_color(const char *s);
int pass_justify(char *s);
int pass_marker(char *s);
void get_color(TOKENS tk,int *ntok,int *curtok,int *pcode,int *plen);
void get_fill(TOKENS tk,int *ntok,int *curtok,int *pcode,int *plen);
void get_font(TOKENS tk,int *ntok,int *curtok,int *pcode,int *plen);
void get_justify(TOKENS tk,int *ntok,int *curtok,int *pcode,int *plen);
void get_marker(TOKENS tk,int *ntok,int *curtok,int *pcode,int *plen);
void gt_xy(int *curtok, TOKENS tk, int *ntok,	int *pcode, int *plen);
void mark_clear(void);
void mystrcpy(char **d,char *s);
void pass_checkmode(void);
//void passt(_itGLESource sc_line_it,TOKENS tk,int *ntok,int *pcode,int *plen);
void spop(int v);
void spush(int v);
void scheck(int v);
//
// used in utils
//
int zpolish(TOKENS tk,int *ntok,int *curtok,char *pcode,int *plen,int *rtype);
void set_global_parser(GLEParser* parser);
GLEParser* get_global_parser();

#endif
