#ifndef INCLUDE_POLISH
#define INCLUDE_POLISH

#define PCODE_EXPR 1
#define PCODE_DOUBLE 2
#define PCODE_VAR 3
#define PCODE_STRVAR 4
#define PCODE_STRING 5
#define PCODE_MORE 6
#define PCODE_NEXT_CMD 7

class GLESub;

class GLEPcodeList : public RefCountObject {
protected:
	RefCountVector<GLEObject> m_ConstObjects;
};

class GLEPcode : public vector<int> {
protected:
	GLEPcodeList* m_PCodeList;
public:
	GLEPcode(GLEPcodeList* list);
	inline void addInt(int val) { push_back(val); };
	inline int getInt(int idx) { return (*this)[idx]; };
	inline void setInt(int idx, int val) { (*this)[idx] = val; };
	void addDouble(double val);
	void addFunction(int idx);
	void addVar(int var);
	void addStrVar(int var);
	void addString(const string& str);
	void addStringNoID(const string& str);
	void show();
	void show(int start);
};

class GLEPolish : public RefCountObject {
protected:
	StringTokenizer m_tokens;
public:
	void polish(const char *expr, GLEPcode& pcode, int *rtype) throw(ParserError);
	void polish(GLEPcode& pcode, int *rtype) throw(ParserError);
	void eval(char *exp, double *x) throw(ParserError);
	void eval_string(const char *exp, string *str, bool allownum = false) throw(ParserError);
	void get_params(GLEPcode& pcode, int np, int* plist, const string& name) throw(ParserError);
	void initTokenizer();
	inline ParserError error(int column, const string& src) const {
		return m_tokens.error(column, src);
	};
	inline ParserError error(const string& src) const {
		return m_tokens.error(src);
	};
};

void polish_eval(char *exp, double *x) throw(ParserError);
void polish_eval_string(const char *exp, string *str, bool allownum = false) throw(ParserError);
void polish(char *expr, char *pcode, int *plen, int *rtype) throw(ParserError);
GLEPolish* get_global_polish();

void stack_op(char *pcode, int *plen, int stk[] , int stkp[], int *nstk,  int i, int p);

#endif
