#include <math.h>
#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string>
#include <vector>
#include <list>
#include <iostream>
using namespace std;

#include "SourceLine.h"
#include "all.h"
#include "mem_limits.h"
#include "token.h"
#include "tokens/Tokenizer.h"

#include "glearray.h"
#include "polish.h"
#include "pass.h"
#include "var.h"

#include "mygraph.h"   /* Prototypes for all the graph routines */
#include "core.h"
#include "cutils.h"
#include "gprint.h"
#include "texinterface.h"
#include "run.h"
#include "eval.h"
#include "name.h"

extern OPKEY op_begin;
string get_b_name(int jj)
{
	for (int i=0; op_begin[i].typ!=0; i++) {
		if( op_begin[i].idx == jj){
			return string(op_begin[i].name);
		}
	}
	return "unknown";
}
void text_def(uchar *ss);
/*
moved to core.cpp
int g_psarrow(double x1, double y1, double x2, double y2, int flag);
int g_arrowline(double dx, double dy, int flag);
int g_arrowpoints(double cx,double cy,double dx,double dy, double *ax1,double *ay1
	,double *ax2,double *ay2, double *nx, double *ny);
int g_arrowline(double x2, double y2, int flag)
*/
void name_join(char *a, char *b, int j, bool curve, double a1, double a2, double d1, double d2) throw(ParserError);

void run_bigfile(char *ss);

void begin_config(const char* block, int *pln, int *pcode, int *cp);
void begin_tex_preamble(int *pln, int *pcode, int *cp);
void begin_tex(int *pln, int *pcode, int *cp);
void begin_surface(int *pln, int *pcode, int *cp) throw(ParserError);
void begin_letz(int *pln, int *pcode, int *cp) throw(ParserError);
void begin_fitz(int *pln, int *pcode, int *cp) throw(ParserError);

class GLEBox {
protected:
	const char* m_Name; // Should be replaced by string* later on
	bool m_HasStroke;
	bool m_HasReverse;
	double m_Add;
	bool m_IsRound;
	double m_Round;
	bool m_IsFilled;
	int m_Fill;
public:
	GLEBox();
	GLEBox(const GLEBox& box);
	void setFill(int fill);
	void setRound(double round);
	void draw(double x1, double y1, double x2, double y2);
	inline void setStroke(bool stroke) { m_HasStroke = stroke; }
	inline bool hasStroke() const { return m_HasStroke; }
	inline void setReverse(bool reverse) { m_HasReverse = reverse; }
	inline bool hasReverse() const { return m_HasReverse; }
	inline bool isFilled() const { return m_IsFilled; }
	inline int getFill() const { return m_Fill; }
	inline bool isRound() const { return m_IsRound; }
	inline double getRound() const { return m_Round; }
	inline void setNamePtr(const char* name) { m_Name = name; }
	inline bool hasName() const { return m_Name != NULL; }
	inline const char* getName() const { return m_Name; }
	inline void setAdd(double add) { m_Add = add; }
	inline double getAdd() const { return m_Add; }
};

class GLEStoredBox : public GLEBox {
public:
	double x1, x2, y1, y2;
protected:
	string m_Name;
	bool m_HasName;
public:
	GLEStoredBox();
	GLEStoredBox(const GLEStoredBox& box);
	void setName(const char* name);
	inline bool hasName() const { return m_HasName; }
	inline const string& getName() const { return m_Name; }
};

class GLEBoxStack {
protected:
	static GLEBoxStack m_Instance;
	vector<GLEStoredBox> m_Boxes;
public:
	static inline GLEBoxStack* getInstance() { return &m_Instance; }
	inline int size() { return m_Boxes.size(); }
	inline void removeBox() { m_Boxes.pop_back(); }
	inline GLEStoredBox* lastBox() { return &m_Boxes.back(); }
	inline GLEStoredBox* newBox() { m_Boxes.push_back(GLEStoredBox()); return lastBox(); }
};

GLEBoxStack GLEBoxStack::m_Instance;

GLEStoredBox* box_start(void);
void box_end(void);

extern int this_line;
extern int trace_on;
static int path_clip[4],path_stroke[4];
static int path_fill[4];
static double path_x[4],path_y[4];
static int npath;
#define true (!false)
#define false 0
int done_open = false;

class GLEFile {
protected:
	bool m_ReadWrite;
	FILE* m_Output;
	StreamTokenizer* m_Input;
	string m_buffer;
public:
	GLEFile();
	~GLEFile();
	void close();
	void open(const char* fname) throw(ParserError);
	bool eof() throw(ParserError);
	char* getToken() throw(ParserError);
	char* readLine() throw(ParserError);
	void gotoNewLine() throw(ParserError);
	void resetLang();
	void setLangChars(int type, const char* str);
	inline void setCommentChars(const char* str) { setLangChars(0, str); }
	inline void setSpaceTokens(const char* str) { setLangChars(1, str); }
	inline void setSingleCharTokens(const char* str) { setLangChars(2, str); }
	inline bool isRead() { return m_ReadWrite; }
	inline void setRdWr(bool rd) { m_ReadWrite = rd; }
	inline FILE* getOutput() { return m_Output; }
};

vector<GLEFile*> g_Files;

int f_getchan(void);
void f_readahead(int chn);
int f_testchan(int chn);
void siffree(char **s);
void f_getline(int chn);
char *f_gettok(int chn);
static int chn;
int f_eof(int chn);
char *f_getnext(int chn);


void f_create_chan(int var, const char* fname, int rd_wr);
void f_close_chan(int idx);


/*---------------------------------------------------------------------------*/
/* pos=   Offset to find the data			*/
/* idx=   For switches, which can only have one value. 	*/
/* The pos is the order the items will be placed in the pcode */
/*
/* Switches 	int 	placed in directly, 1 present, 0 not present
/* expressions 	LONG* 	pointed to, 0 if not present.
/* color/fill	LONG* 	Pointer to exp 0 if not present.
/* marker	LONG*	Pointer to exp 0 if not present.
/* lstyle 	LONG*	Pointer to exp 0 if not present.
/* font 	int* 	Pointer to string expression.
*/

extern char *mainkey[];
extern int gle_debug;
int can_fillpath = false;

#define readval(x) eval(pcode,&cp,&x,ostr,&otyp)
#define readxy(x,y) {eval(pcode,&cp,&x,ostr,&otyp);eval(pcode,&cp,&y,ostr,&otyp);}
#define readstr(s) eval(pcode,&cp,&x,s,&otyp)
#define readlong(i) i = *(pcode+cp++)
#define readvalp(x,p) {zzcp=0; eval(p,&zzcp,&x,ostr,&otyp);}
#define dbg if ((gle_debug & 16)>0)
static int for_level,for_skip,for_loop,if_findelse,if_findendif,if_level;

void for_init(void) {
	for_loop = 0;
	for_level = 0;
	for_skip = 0;
	if_findelse = 0;
	if_findendif = 0;
	if_level = 0;
}

#define PCODE_UNKNOWN_COMMAND 1

void byte_code_error(int err) throw(ParserError) {
	char str[50];
	TokenizerPos pos;
	pos.setColumn(-1);
	sprintf(str, "byte code error (code = %d)", err);
	ParserError err_exp(str, pos, NULL);
	throw err_exp;
}

void clear_run() {
	char ss[500];
	npath = 0;
	done_open = false;
	g_get_type(ss);
	if (strstr(ss,"FILLPATH")!=NULL) can_fillpath = true;
	else can_fillpath = false;
}

int gle_is_open() {
	return done_open;
}

/*---------------------------------------------------------------------------*/
/* Input is pcode, output is text equiv.*/
#ifdef NEW_WAY
void do_pcode(SourceLine &SLine, _PCode &PCode)
/* srclin = The source line number */
/* pcode =  a pointer to the pcode output buffer */
/* plen =   a pointer to the length of the pcode output */
{
	//
	// - hack in
	//
	int psrclin	= SLine.line_no;
	int *srclin = &psrclin;

	int *pcode = &PCode[0];
	int plen = PCode.size();
	int *pend = &PCode[PCode.size()-1];

#else
void do_pcode(SourceLine &SLine,int *srclin, int *pcode, int plen, int *pend) throw(ParserError)
/* srclin = The source line number */
/* pcode =  a pointer to the pcode output buffer */
/* plne =   a pointer to the length of the pcode output */
{
#endif
	double oval;
	union {double d; int l; int ll[2];} both;
	int otyp,cp=0,i,zzcp;
	static double loopstep[30];
	static int loopadr[30],nloop;
	double lll,rrr,uuu,ddd;
	char ostr[255];
	char *pss;
	char *zzz;
	string temp_str;
	union ppboth {int l; short s[2];} bth;
	double x,y,sx,sy,ox,oy,x1,y1,x2,y2,x3,y3,a1,a2,r,z,rx,ry;
	int t,j,jj,jj2,ptr,ptr_fill,mask_just,mask_nostroke,marrow,mask_ASCII85;
	static char ss[255],ss2[80],ss1[90];
	this_line = *srclin;
	while (cp < plen) {
		int cmd_plen = pcode[cp++];
		int p = pcode[cp++];
		cmd_name(p,&pss);
		//printf("CMD:%d{%s}\n",p,pss);
		//sprintf(ss,"Command %d {%s} \n",p,pss);
		g_source(ss);
		if (if_findelse) {
			dbg gprint("SKIP in skip findelse \n");
			switch (p) {
				case 13 : /* else */
					if (if_level==0) {
						if_findelse = false;
					}
					break;
				case 14 : /* end xxx */
					readlong(jj);
					if (jj==6) { /* end if */
						if (if_level==0) {
							if_findelse = false;
						} else if_level--;
					}
					break;
				case 22 : /* if */
					if_level++;
					break;
			}
			return;
		}
		if (if_findendif) {
			dbg gprint("SKIP, findendif \n");
			switch (p) {
				case 14 : /* end xxx */
					readlong(jj);
					if (jj==6) { /* end if */
						if (if_level==0) {
							if_findendif = false;
						} else if_level--;
					}
					//else gprint("Wrong end %d \n",jj); dont need this
					// since it is ok to have end xxx inside an else block
					break;
				case 22 : /* if */
					if_level++;
					break;
			}
			return;
		}
		if (for_skip) {
			switch (p) {
				case 47: /* until */
				case 18 : /* for */
					for_level++;
					break;
				case 30 : /* next */
					if (for_level==0) {
						for_skip = false;
					} else for_level--;
					break;
			}
			return;
		}
		if (!done_open) {
			//
			// list here all the commands that can come before SIZE
			// see keywords.cpp for more numbers
			//
			i = *(pcode + cp);
			if (p != 42  &&           // size
			    p != 53  &&           // comment
			    p != 0   &&           // blank line
			    p != 65  &&           // PSCOMMENT
			    p != 66  &&           // BB_TWEAK
			    p != 77  &&           // papersize
			    p != 78  &&		  // margins
			    p != 79  &&           // orientation
			    !(p == 5 && i == 22)  // begin config
			) {
				g_open(get_input_file().c_str());
				done_open = true;
			}
		}
		switch (p)
		{
		case 53: /* comment */
		case 0: /* blank line */
		break;

		case 65: // PSCOMMENT
			strcpy(ss,(char *) (pcode+cp));
		/*	readstr(ss); */
			g_pscomment(ss);
		break;
		case 66: // BBTWEAK
			g_psbbtweak();
		break;
		case 1:  /* ALINE x y ARROW both | start | end */
			readval(x);
			readval(y);
			dbg gprint("x=%f, y=%f \n",x,y);
			marrow = *(pcode + (cp++));
			ptr = *(pcode + cp); /* curve angle1 angle2 d1 d2 */
			if (ptr) {
				cp += ptr;
				readxy(x2, y2);
				readxy(x3, y3);
				g_arrowcurve(x, y, marrow, x2, y2, x3, y3, can_fillpath);
			} else {
				g_arrowline(x,y,marrow,can_fillpath);
			}
			break;
		  case 2:  /* AMOVE */
			readval(x);
			readval(y);
			g_move(x,y);
			break;
		  case 73:  /* SETPOS */
			readval(x);
			readval(y);
			g_set_pos(x,y);
			break;
		  case 3: /* ARC */
			readval(r);
			readxy(a1,a2);
			g_get_xy(&ox,&oy);
			//
			// -- get options center takes two arguments
			//
			// arrow is first
			marrow = *(pcode + (cp++));
			// center is a type val 2
			ptr = *(pcode + cp); /* cx,cy */
			if (ptr) {
				readvalp(x,pcode + cp + ptr);
				ox+=x;
			}
			ptr = *(pcode + cp + 1); /* cx,cy */
			if (ptr) {
				readvalp(y,pcode + cp + ptr);
				oy+=y;
			}
			g_arc(r,a1,a2,ox,oy,marrow,can_fillpath);
			break;
		  case 4: /* ARCTO */
			readxy(x1,y1);
			readxy(x2,y2);
			readval(r);
			g_get_xy(&ox,&oy);
			g_arcto(x1+ox,y1+oy,x2+ox+x1,y2+oy+y1,r);
			break;
		  case 51: /* Assignment  var=exp */
		 // printf("Assigment\n");
			readlong(jj);
			readval(x);
			if (otyp==1) var_set(jj,x);
			if (otyp==2) var_setstr(jj,ostr);
			break;
		  case 5:  /* BEGIN box | path | scale | rotate | EXTERNAL */
			g_flush();
			i = *(pcode + cp++);
			//cout << "BEGIN " << i<<get_b_name(i) << endl;
			switch (i) {
				case 1: /* PATH stroke fill clip */
					npath++;
					g_get_xy(&path_x[npath],&path_y[npath]);
					path_stroke[npath] = *(pcode + cp);
					ptr = *(pcode + ++cp);
					path_fill[npath] = 0;
					if (ptr) {
						readvalp(z,pcode+cp+ptr);
						memcpy(&path_fill[npath],&z,4);
					}
					path_clip[npath] = *(pcode + ++cp);
					g_set_path(true);
					g_newpath();
					break;
				case 2: /* BOX add, fill, nobox, name, round */
					{
						GLEStoredBox* box = box_start();
						ptr = *(pcode + cp);
						if (ptr) {
							readvalp(z, pcode+cp+ptr);
							box->setAdd(z);
						}
						ptr = *(pcode + ++cp);
						if (ptr) {
							readvalp(z,pcode+cp+ptr);
							memcpy(&both.d,&z,sizeof(z));
							box->setFill(both.l);
						}
						if (*(pcode + ++cp)) {
							box->setStroke(false);
						}
						ptr = *(pcode + ++cp);
						if (ptr) {
							readvalp(z,pcode+cp+ptr);
							box->setRound(z);
						}
						ptr = *(pcode + ++cp);
						if (ptr) {
							readvalp(z,pcode+cp+ptr);
							box->setName(ostr);
						}
					}
					break;
				case 3: /* SCALE */
					readxy(x,y);
					g_gsave();
					g_scale(x,y);
					break;
				case 21: /* shear */
					readxy(x,y);
					g_gsave();
					g_shear(x,y);
					break;
				case 4: /* ROTATE */
					readval(x);
					g_gsave();
					g_rotate(x);
					break;
				case 5: /* TRANSLATE */
					readval(x); readval(y);
					g_gsave();
					g_translate(x,y);
					g_rmove(0.0,0.0);
					break;
				case 6: /* if */
				case 7: /* sub */
					gprint("odd begin %d\n",i);
					break;
				case 8: /* name */
					{
						GLEStoredBox* box = box_start();
						box->setStroke(false);
						readval(z);
						box->setName(ostr);
					}
					break;
				case 9: /* text */
					z = 0;
					ptr = *(pcode + cp);
					/* read width of text box */
					if (ptr) readvalp(z,pcode+cp+ptr);
					/* get justify of text box */
					t = (int)*(pcode + cp+2);
					begin_text(srclin,pcode,&cp,z,t);
					break;
				case 18: /* tab  (tabbing, table) */
					begin_tab(srclin,pcode,&cp);
					break;
				case 10: /* graph */
					begin_graph(srclin,pcode,&cp);
					break;
				case 11: /* xaxis */
				case 12: /* yaxis */
				case 13: /* x2axis */
				case 14: /* y2axis */
					break;
				case 16: /* KEY */
					begin_key(srclin,pcode,&cp);
					break;
				case 19: /* begin  clip */
					g_beginclip();
					break;
				case 17: /* ORIGIN */
					g_gsave();
					g_get_xy(&x,&y);
					g_translate(x,y);
					g_move(0.0,0.0);
					break;
				case 22: /* config */
					readval(z);
					begin_config(ostr,srclin,pcode,&cp);
					break;
				case 23: /* tex preamble */
					begin_tex_preamble(srclin,pcode,&cp);
					break;
				case 24: /* surface */
					begin_surface(srclin,pcode,&cp);
					break;
				case 25: /* letz */
					begin_letz(srclin,pcode,&cp);
					break;
				case 26: /* fitz */
					begin_fitz(srclin,pcode,&cp);
					break;
				case 27: /* fit */
					// begin_fit(srclin,pcode,&cp);
					break;
				case 28: /* tex */
					begin_tex(srclin,pcode,&cp);
					break;
				default: /* error  */
					gprint("Error, illegal begin option %d \n",i);
					break;
			}
			break;
		  case 6: /* BEZIER */
			readxy(x1,y1);
			readxy(x2,y2);
			readxy(x3,y3);
			g_bezier(x1,y1,x2,y2,x3,y3);
			break;
		  case 7:  /* BOX x y justify FILL fexp NAME string ROUND val NOSTROKE */
	  		{
				GLEBox box;
				readval(x); readval(y);
				g_get_xy(&ox,&oy);
				x += ox; y += oy;
				mask_just = *(pcode + cp);
				g_dojust(&ox,&oy,&x,&y,mask_just);
				ptr = *(pcode + ++cp);
				if (ptr) {
					readvalp(z,pcode+cp+ptr);
					memcpy(&both.d,&z,sizeof(z));
					box.setFill(both.l);
				}
				if (*(pcode + ++cp)) {
					box.setStroke(false);
				}
				if (*(pcode + ++cp)) {
					box.setReverse(true);
				}
				ptr = *(pcode + ++cp);
				if (ptr) {
					readvalp(z,pcode+cp+ptr);
					box.setRound(z);
				}
				ptr = *(pcode + ++cp);
				if (ptr) {
					readvalp(z,pcode+cp+ptr);
					box.setNamePtr(ostr);
				}
				box.draw(ox, oy, x, y);
			}
			break;
		  case 52:  /* CALL or @ */
			readval(r);
			break;
		  case 8:  /* CIRCLE */
			readval(r);
			g_get_xy(&ox,&oy);
			sx = ox; sy = oy;
			mask_just = *(pcode + cp++);
			x = ox + r;
			y = oy + r;
			g_dojust(&ox,&oy,&x,&y,mask_just);
			g_move(ox,oy);
			mask_nostroke = *(pcode + cp++);
			ptr_fill = *(pcode + cp);
			if (ptr_fill) {
				readvalp(z,pcode + cp + ptr_fill);
				memcpy(&both.l,&z,4);
				g_set_fill(both.l);
				g_circle_fill(r);
			}
			if (!mask_nostroke)
				g_circle_stroke(r);
			g_move(sx,sy);
			break;
		case 70:  /* ELLIPSE */
			readval(rx);  //x radius
			readval(ry);  //y radius
			g_get_xy(&ox,&oy);
			sx = ox;
			sy = oy;
			mask_just = *(pcode + cp++);
			x = ox + rx;
			y = oy + ry;
			g_dojust(&ox,&oy,&x,&y,mask_just);
			g_move(ox,oy);
			mask_nostroke = *(pcode + cp++);
			ptr_fill = *(pcode + cp);
			if (ptr_fill) {
				readvalp(z,pcode + cp + ptr_fill);
				memcpy(&both.l,&z,4);
				g_set_fill(both.l);
				g_ellipse_fill(rx,ry);
			}
			if (!mask_nostroke)
				g_ellipse_stroke(rx,ry);
			g_move(sx,sy);
			break;
		case 71: /* ELLIPTICAL_ARC  */
			readxy(rx,ry);
			readxy(a1,a2);
			g_get_xy(&ox,&oy);
			//
			// -- get options center takes two arguments
			//
			// arrow is first
			marrow = *(pcode + (cp++));
			// center is a type val 2
			ptr = *(pcode + cp); /* cx,cy */
			if (ptr) {
				readvalp(x,pcode + cp + ptr);
				ox+=x;
			}
			ptr = *(pcode + cp + 1); /* cx,cy */
			if (ptr) {
				readvalp(y,pcode + cp + ptr);
				oy+=y;
			}
			g_elliptical_arc(rx,ry,a1,a2,ox,oy,marrow,can_fillpath);
			break;
		case 72: /* ELLIPTICAL_NARC  */
			readxy(rx,ry);
			readxy(a1,a2);
			g_get_xy(&ox,&oy);
			//
			// -- get options center takes two arguments
			//
			// arrow is first
			marrow = *(pcode + (cp++));
			// center is a type val 2
			ptr = *(pcode + cp); /* cx,cy */
			if (ptr) {
				readvalp(x,pcode + cp + ptr);
				ox+=x;
			}
			ptr = *(pcode + cp + 1); /* cx,cy */
			if (ptr) {
				readvalp(y,pcode + cp + ptr);
				oy+=y;
			}
			g_elliptical_narc(rx,ry,a1,a2,ox,oy,marrow,can_fillpath);
			break;
		  case 9: /* CLOSEPATH */
			g_closepath();
			break;
		  case 10: /* CURVE  x y x y ...  change to BEGIN CURVE ... END CURVE */
			g_curve(pcode+cp);
			break;
		  case 11: /* DEFINE  MARKER name  subname */
			break;
		  case 12: /* DFONT */
			readstr(ss);
			g_dfont(ss);
			break;
		  case 13: /* ELSE */
			if_findendif = true;
			break;
		  case 14: /* END */
			readlong(jj);
			//cout << "END "<<jj<<get_b_name(jj)<<endl;
			switch (jj) {
			  case 1: /* end path  (stroke,fill,clip) */
				if (path_fill[npath]!=0) {
					g_set_fill(path_fill[npath]);
					g_fill();
				}
				if (path_stroke[npath]==static_cast<int>(true)) g_stroke();
				if (path_clip[npath] == static_cast<int>(true)) g_clip();
				if (npath==0) {
					g_throw_parser_error("too many end path's");
					break;
				}
				g_move(path_x[npath],path_y[npath]);
				npath--;
				g_set_path(false);
				break;
			  case 2: /* end box */
				box_end();
				break;
			  case 3: /* end scale */
			  case 21: /* end shear */
			  case 4: /* end rotate */
			  case 5: /* end translate */
				g_grestore();
				break;
			  case 6: /* end if */
				/* do nothing,  all done elsewhere I think?? */
				break;
			  case 8: /* end name */
				box_end();
				break;
			  case 19: /* clip */
				g_endclip();
				break;
			  case 18: /* tab */
			  case 9: /* text */
				break;
			  case 17: /* end origin */
				g_grestore();
				break;
	 		  default :
				gprint("Not a valid end %d \n",jj);
			}
			break;
		  case 15: /* FCLOSE */
			readval(x);
			f_close_chan((int) x);
			break;
		  case 16: /* FILL */
			g_fill();
			break;
		  case 61 : /* fread CHAN a$ x   */
		  case 62 : /* freadln */
	  		{
				readlong(t);
				if (t!=49) gprint("FREAD, PCODE ERROR, %d  cp %d plen %d\n",t,cp,plen);
				readlong(i);
				readlong(t);
				var_get(i,&x);
				chn = (int) x;
				chn = f_testchan(chn);
				if (chn == -1) break;
				GLEFile* file = g_Files[chn];
				if (p == 61 && cp >= cmd_plen) {
					gprint("FREAD requires at least two parameters\n");
					break;
				}
				while (cp < cmd_plen) {
					readlong(t);
					if (t!=49) gprint("FREAD2, PCODE ERROR, %d  cp %d plen %d\n",t,cp,plen);
					readlong(i); /* variable number */
					readlong(t); /* type of variable */
					if (t==1) {
						x = atof(file->getToken());
						var_set(i,x);
					} else {
						var_setstr(i,file->getToken());
					}
				}
				if (p==62) file->gotoNewLine();
			} break;
		  case 63 : /* fwrite */
		  case 64 : /* fwriteln */
	  		{
				readlong(t);
				readlong(t);
				readval(x);
				chn = f_testchan((int) x);
				if (chn == -1) break;
				GLEFile* file = g_Files[chn];
				if (file->isRead()) {
					gprint("You cannot WRITE from a file open for READ {#%d}\n",chn);
					break;
				}
				temp_str = "";
				while (cp < cmd_plen) {
					readlong(t);
					if (t!=49) gprint("WRITE, PCODE ERROR, %d  cp %d plen %d\n",t,cp,plen);
					readlong(t);
					if (t==1) {
						readval(x);
						sprintf(ss,"%g ",x);
					} else {
						readstr(ss);
					}
					temp_str += ss;
				}
				if (p==64) temp_str += "\n";
				fprintf(file->getOutput(),"%s",temp_str.c_str());
			} break;
		  case 17:  /* FOPEN "a.a" inchan read|write */
			readstr(ss);
			readlong(i); /* channel variable */
			readlong(jj); /* 0 = read, 1 = write */
			f_create_chan(i, ss, jj);
			break;
		  case 75 : /* fgetline */
			{
				readval(x);
				chn = f_testchan((int) x);
				if (chn == -1) break;
				readlong(i);
				var_setstr(i, g_Files[chn]->readLine());
			} break;
		  case 76 : /* ftokenizer commenttoks spacetoks singlechartoks */
			{
				readval(x);
				chn = f_testchan((int) x);
				if (chn == -1) break;
				GLEFile* file = g_Files[chn];
				file->resetLang();
				readval(x);
				file->setCommentChars(ostr);
				readval(x);
				file->setSpaceTokens(ostr);
				readval(x);
				file->setSingleCharTokens(ostr);
			} break;
		  case 77: /* papersize */
		  	readlong(jj);
			if (jj == 1) {
				readlong(jj);
				g_set_pagesize(jj);
			} else {
				readxy(x2, y2);
				g_set_pagesize(x2, y2);
			}
		  	break;
		  case 78: /* margins */
			readxy(x2, y2);
			readxy(x3, y3);
			g_set_margins(x2, y2, x3, y3);
		  	break;
		  case 79: /* orientation */
	  	  	readlong(jj);
			g_set_landscape(jj);
			break;			
		  case 18: /* FOR   v,exp,exp,op,exp */
			if (for_loop) {
				readlong(jj);
				readval(x);
				readval(y);
				var_get(jj,&x);
				x = x + loopstep[nloop];
				var_set(jj,x);
				var_get(jj,&x);
				dbg gprint("got back %f \n",x);
				if ( (x > y  && loopstep[nloop]>=0) ||
				     (y > x  && loopstep[nloop]<=0) ) {
					for_skip = true;
					nloop--;
				}
				for_loop = false;
				break;
			}
			loopadr[++nloop] = *srclin;
			readlong(jj);	  /* variable */
			readval(x);
			readval(y);
			var_set(jj,x);
			loopstep[nloop] = 1;
			p = *(pcode + cp);
			if (p) {
				readvalp(z,pcode + cp + p);
				loopstep[nloop] = z;
			}
			break;
		  case 19: /* GOTO */
		  case 20: /* GSAVE */
			g_gsave();
			break;
		  case 54: /* GRESTORE */
			g_grestore();
			break;
		  case 21: /* ICON */
			break;
		  case 22: /* IF EXP */
			readval(x);
			dbg gprint("If expression = %f \n",x);
			if (x==0) if_findelse = true;	/* exp was false */
			break;
		  case 23: /* INCLUDE (done in pass,  already included) */
			break;
		  case 24: /* INPUT */
		  	break;
		  case 25: /* JOIN  str1,type,str2 */
			{
				readval(z);
				strcpy(ss1,ostr);
				readlong(jj);
				readval(z);
				strcpy(ss2,ostr);
				ptr = *(pcode + cp); /* curve angle1 angle2 d1 d2 */
				if (ptr) {
					cp += ptr;
					readxy(x2, y2);
					readxy(x3, y3);
					name_join(ss1, ss2, (int)jj, true, x2, y2, x3, y3);
				} else {
					name_join(ss1, ss2, (int)jj, false, 0, 0, 0, 0);
				}
			}
			break;
		  case 26: /* MARKER */
			readval(x);
			memcpy(&both.d,&x,sizeof(x));
			jj = both.l;
			g_get_hei(&z);
			y = 1;
			if (*(pcode+cp)!=0) readval(y);
			y = y * z;
			g_marker((int) both.l,y);
			break;
		  case 27: /* MOVE  name */
			readval(z);
			name_get(ostr,&ox,&oy,&x,&y);
			x = ox;
			y = oy;
			g_dojust(&ox,&oy,&x,&y,jj);
			g_move(x+(x-ox),y+(y-oy));
			break;
		  case 28: /* NARC */
			readval(r);
			readxy(a1,a2);
			g_get_xy(&ox,&oy);
			//
			// -- get options center takes two arguments
			//
			// arrow is first
			marrow = *(pcode + (cp++));
			// center is a type val 2 shifts the center position
			ptr = *(pcode + cp); /* cx,cy */
			if (ptr) {
				readvalp(x,pcode + cp + ptr);
				ox+=x;
			}
			ptr = *(pcode + cp + 1); /* cx,cy */
			if (ptr) {
				readvalp(y,pcode + cp + ptr);
				oy+=y;
			}
			g_narc(r,a1,a2,ox,oy,marrow,can_fillpath);
			break;
		  case 29: /* NEWPATH */
			g_newpath();
			break;
		  case 30:  /* NEXT */
			if (nloop == 0) {
				g_throw_parser_error("next without for");
				break;
			}
			while (pcode[cp] == PCODE_MORE) {
				cp++;
				/* read vars */
				readlong(jj);
			}
			*srclin = loopadr[nloop]-1;
			dbg gprint("%FOR   Setting line back to %d  nloop %d \n ",*srclin,nloop);
			for_loop = true;
			break;
		  case 31: /* PIE ,, not implemented yet */
			break;
		  case 57: /* plotter fonts */
			plotter_fonts();
			break;
		  case 58: /* bigfile "filename" */
		  printf("BIGFILE no longer supported, sorry. use include");
	//		readstr(ss);
	//		gle_strlwr(ss);		/* bit of a kludge but ... */
	//		run_bigfile(ss);
			break;
		  case 55: /* Postscript filename x y */
			readstr(ss);
			readxy(x1,y1);
			g_postscript(ss,x1,y1);
			break;
		  case 67: /* TIFF filename x y */
			readstr(ss); temp_str = ss;
			readxy(x1,y1);
			g_bitmap(temp_str, x1, y1, BITMAP_TYPE_TIFF);
			break;
		  case 68: /* BITMAP file width height [type colors compress dpi greyscale resize] */
			{
				readstr(ss); temp_str = ss;
				readxy(x1,y1);
	// The options type, compress, dpi, greyscale, ...
	// will be implemented in the near future (Jan Struyf 01//05/05).
				cp += 5;
				int bm_type = 0;
				ptr = *(pcode + cp); /* type */
				if (ptr) {
					readvalp(z, pcode + cp + ptr);
					bm_type = g_bitmap_string_to_type(ostr);
				}
				g_bitmap(temp_str, x1, y1, bm_type);
			}
			break;
		  case 69: /* BITMAP_INFO file width, height [type] */
	  		{
				readstr(ss); temp_str = ss;
				readlong(jj); readlong(jj2);
				int bm_type = 0;
				ptr = *(pcode + cp); /* type */
				if (ptr) {
					readvalp(z, pcode + cp + ptr);
					bm_type = g_bitmap_string_to_type(ostr);
				}
				g_bitmap_info(temp_str, jj, jj2, bm_type);
			}
			break;
		  case 33: /* RBEZIER */
			readxy(x1,y1);
			readxy(x2,y2);
			readxy(x3,y3);
			g_get_xy(&ox,&oy);
			x1 += ox;  x2 += ox;  x3 += ox;
			y1 += oy;  y2 += oy;  y3 += oy;
			g_bezier(x1,y1,x2,y2,x3,y3);
			break;
		  case 34: /* REGION */
			break;
		  case 50: /* RETURN exp */
			readval(x);
			if (otyp == 1) {
				sub_set_return(x);
			} else {
				sub_set_return_str(ostr);
			}
			break;
		  case 35: /* REVERSE */
			g_reverse();
			break;
		  case 36:  /* RLINE */
			readval(x);
			readval(y);
			g_get_xy(&ox,&oy);
			marrow = *(pcode + (cp++));
			ptr = *(pcode + cp); /* curve angle1 angle2 d1 d2 */
			if (ptr) {
				cp += ptr;
				readxy(x2, y2);
				readxy(x3, y3);
				g_arrowcurve(x+ox, y+oy, marrow, x2, y2, x3, y3, can_fillpath);
			} else {
				g_arrowline(x+ox,y+oy,marrow,can_fillpath);
			}
			break;
		  case 37:  /* RMOVE */
			readval(x);
			readval(y);
			g_get_xy(&ox,&oy);
			g_move(x+ox,y+oy);
			break;
		  case 38: /* ROTATE */
			readval(x);
			g_rotate(x);
			break;
		  case 39: /* SAVE  name */
			g_get_xy(&x,&y);
			readval(z);
			name_set(ostr,x,y,x,y);
			break;
		  case 40: /* SCALE */
			readxy(x,y);
			g_scale(x,y);
			break;
		  case 41: /* SET */
			while (cp < cmd_plen) {
				cp++;
				dbg gprint("set sub command %d \n",(*(pcode+i-1)-500));
				switch (*(pcode+cp-1)-500) {
				  case 1: /* height */
					readval(x);
					g_set_hei(x);
					break;
				  case 2: /* font */
					readval(x);
					memcpy(&both.l,&x,4);
					g_set_font(both.l);
					break;
				  case 3: /* justify */
					readlong(jj);
					g_set_just(jj);
					break;
				  case 4: /* color */
					readval(x);
					memcpy(&both.l,&x,4);
					g_set_color(both.l);
					break;
				  case 5: /* dashlen */
					readval(x);
					g_set_line_styled(x);
					break;
				  case 6: /* dash */
					readval(x);
					i = (int) x;
					sprintf(ss,"%d",i);
					g_set_line_style(ss);
					break;
				  case 7: /* lwidth */
					readval(x);
					g_set_line_width(x);
					break;
				  case 10: /* fontlwidth */
					readval(x);
					g_set_font_width(x);
					break;
				  case 8: /* join */
					readlong(jj);
					g_set_line_join(jj);
					break;
				  case 9: /* cap */
					readlong(jj);
					g_set_line_cap(jj);
					break;
				  case OP_SET_ARROW_SIZE:
				  	readval(x);
					g_set_arrow_size(x);
					break;
				  case OP_SET_ARROW_ANGLE:
				  	readval(x);
					g_set_arrow_angle(x);				
					break;
				  case OP_SET_IMAGE_FORMAT:
	                                readstr(ss);
				  	g_set_pdf_image_format(ss);
					break;				
				  default :
					gprint("Not a valid set sub command {%d} i=%d \n",*(pcode+i),i);
				}
			}
			break;
		  case 42: /* size x y [box]*/
			readxy(x,y);
			g_set_size(x, y, *(pcode + cp++));
			break;
		  case 43: /* STROKE */
			g_stroke();
			break;
		  case 44: /* SUB */
			readlong(jj);
			sub_get_startend(jj,&i,&j);
			*srclin = j;	/* skip past the subroutine */
			break;
		  case 45: /* TEXT */
			strcpy(ss,(char *) (pcode+cp));
			/*readstr(ss);*/
			g_text(ss);
			g_get_bounds(&x1,&y1,&x2,&y2);
			break;
		  case 60: /* DEFMARKER */
			break;
		  case 59: /* TEXTDEF */
			strcpy(ss,(char *) (pcode+cp));
			text_def((unsigned char*) ss);
			break;
		  case 46: /* TRANSLATE */
			readxy(x,y);
			g_translate(x,y);
			break;
		  case 47: /* UNTIL */
			readval(x);
			if (!for_loop) loopadr[++nloop] = *srclin;
			for_loop = true;
			if (x) {for_skip = true; for_loop = false; nloop--;}
			break;
		  case 48: /* WHILE */
			break;
		  case 32: /* PRINT */
		  case 49: /* WRITE */
			g_get_xy(&ox,&oy);
			temp_str = "";
			while (cp < cmd_plen) {
				readlong(t);
				if (t!=49 && t!=32) gprint("WRITE, PCODE ERROR, %d  cp %d plen %d\n",t,cp,plen);
				readlong(t);
				if (t == 1) {
					readval(x);
					sprintf(ss,"%g ",x);
				} else {
					readstr(ss);
				}
				temp_str += ss;
			}
			if (p == 49) {
				/* WRITE */
				g_text((char*)temp_str.c_str());
				g_move(ox,oy);
			} else {
				/* PRINT */
				g_message((char*)temp_str.c_str());
			}
			break;
		  case 74: /* TeX */
			{
				x = 0.0;
				readval(z);
				TeXObject* tex_obj = TeXInterface::getInstance()->draw(ostr);
				ptr = *(pcode + cp); /* add */
				if (ptr) {
					readvalp(x, pcode + cp + ptr);
				}
				ptr = *(pcode + ++cp); /* name */
				if (ptr) {
					readvalp(z, pcode + cp + ptr);
					tex_obj->getDimensions(&x1,&y1,&x2,&y2);
					x1 -= x; x2 += x; y1 -= x; y2 += x;
					name_set(ostr,x1,y1,x2,y2);
				}
			}
			break;
		  default :
		  	byte_code_error(PCODE_UNKNOWN_COMMAND);
		}
		// begin can't be combined with other commands
		if (p == 5) break;
		cp = cmd_plen;
	}
	*pend = cp;
}

GLEBox::GLEBox() {
	m_Name = NULL;
	m_HasStroke = true;
	m_HasReverse = false;
	m_Add = 0.0;
	m_IsRound = false;
	m_IsFilled = false;
}

GLEBox::GLEBox(const GLEBox& box) {
	m_Name = box.getName();
	m_HasStroke = box.hasStroke();
	m_HasReverse = box.hasReverse();
	m_Add = box.getAdd();
	m_IsRound = box.isRound(); m_Round = box.getRound();
	m_IsFilled = box.isFilled(); m_Fill = box.getFill();
}

void GLEBox::setFill(int fill) {
	m_IsFilled = true;
	m_Fill = fill;
}

void GLEBox::setRound(double round) {
	m_IsRound = true;
	m_Round = round;
}

void do_arcto(double x1, double y1, double x2, double y2, double r) {
	double ox, oy;
	g_get_xy(&ox,&oy);
	g_arcto(x1+ox,y1+oy,x2+ox+x1,y2+oy+y1,r);
}

void GLEBox::draw(double x1, double y1, double x2, double y2) {
	double ox, oy;
	x1 -= getAdd(); y1 -= getAdd();
	x2 += getAdd(); y2 += getAdd();
	g_get_xy(&ox, &oy);
	if (isRound()) {
		int oldjoin;
		g_get_line_join(&oldjoin);
		g_set_line_join(1);
		g_set_path(true);
		g_newpath();
		g_move(x1+getRound(), y2);
		g_arcto(x1, y2, x1, y2-getRound(), getRound());
		g_line(x1, y1+getRound());
		g_arcto(x1, y1, x1+getRound(), y1, getRound());
		g_line(x2-getRound(), y1);
		g_arcto(x2, y1, x2, y1+getRound(), getRound());
		g_line(x2, y2-getRound());
		g_arcto(x2, y2, x2-getRound(), y2, getRound());
		g_closepath();
		if (isFilled()) {
			g_set_fill(getFill());
			g_fill();
		}
		if (hasStroke()) {
			g_stroke();
		}
		g_set_path(false);
		g_set_line_join(oldjoin);
	} else {
		if (isFilled()) {
			g_set_fill(getFill());
			g_box_fill(x1, y1, x2, y2);
		}
		if (hasStroke()) {
			g_box_stroke(x1, y1, x2, y2, hasReverse());
		}
	}
	if (hasName()) {
		name_set((char*)getName(), x1, y1, x2, y2);
	}
	g_move(ox, oy);
}

GLEStoredBox::GLEStoredBox() : GLEBox() {
	x1 = 0.0; x2 = 0.0; y1 = 0.0; y2 = 0.0;
	m_HasName = false;
}

GLEStoredBox::GLEStoredBox(const GLEStoredBox& box) : GLEBox(box) {
	x1 = box.x1; x2 = box.x2; y1 = box.y1; y2 = box.y2;
	m_HasName = box.hasName(); m_Name = box.getName();
}

void GLEStoredBox::setName(const char* name) {
	m_HasName = true;
	m_Name = name;
}

GLEStoredBox* box_start(void) {
	GLEStoredBox* box = GLEBoxStack::getInstance()->newBox();
	g_get_bounds(&box->x1, &box->y1, &box->x2, &box->y2);
	g_init_bounds();
	return box;
}

void box_end(void) {
	double x1, y1, x2, y2;
	GLEBoxStack* stack = GLEBoxStack::getInstance();
	if (stack->size() <= 0) {
		gprint("Too many end boxes \n");
		return;
	}
	g_get_bounds(&x1, &y1, &x2, &y2);
	if (x1 > (x2+100)) {
		gprint("Empty box? %g %g ", x1, x2);
		return;
	}
	GLEStoredBox* box = stack->lastBox();
	box->setNamePtr(box->hasName() ? box->getName().c_str() : NULL);
	box->draw(x1, y1, x2, y2);
	if (box->x1 <= box->x2) {
		g_set_bounds(box->x1, box->y1);
		g_set_bounds(box->x2, box->y2);
	}
	stack->removeBox();
}

void nm_adjust(int jj,double *sx, double *sy, double ex, double ey, double x1, double y1, double x2, double y2);
void nm_point(int jj,double *rx, double *ry, double x1, double y1, double x2, double y2);
void nm_split(char *s, char *n, char *p);

void name_join(char *o1, char *o2, int marrow, bool curve, double a1, double a2, double d1, double d2)  throw(ParserError) {
	char n1[40],n2[40],p1[9],p2[9],*ss;
	double sx,sy,ex,ey,x,y,x1,y1,x2,y2,x3,y3,x4,y4;
	int i,jj1,jj2;

	if (str_i_str(o1,".H")!=0 || str_i_str(o1,".V")!=0) {
		ss = o1; o1 = o2; o2 = ss;
		if (marrow==2) marrow = 1;
		else if (marrow==1) marrow = 2;
	}
	nm_split(o1,n1,p1);
	nm_split(o2,n2,p2);

	if (!name_get(n1,&x1,&y1,&x2,&y2) ||
	    !name_get(n2,&x3,&y3,&x4,&y4)) return;

	jj1 = pass_justify(p1);
	jj2 = pass_justify(p2);

	nm_point(jj1,&sx,&sy,x1,y1,x2,y2);
	ex = sx; ey = sy;
	nm_point(jj2,&ex,&ey,x3,y3,x4,y4);

	nm_adjust(jj1,&sx,&sy,ex,ey,x1,y1,x2,y2);
	nm_adjust(jj2,&ex,&ey,sx,sy,x3,y3,x4,y4);

	g_move(sx,sy);
	if (marrow==2) marrow = 1;
	else if (marrow==1) marrow = 2;

	if (curve) {
		g_arrowcurve(ex, ey, marrow, a1, a2, d1, d2, can_fillpath);
	} else {
		g_arrowline(ex, ey, marrow, can_fillpath);
	}
}

void name_to_point(char *o1, double *sx, double *sy) throw(ParserError) {
	char n1[40], p1[9];
	double x1, y1, x2, y2;
	nm_split(o1, n1, p1);
	if (name_get(n1, &x1, &y1, &x2, &y2)) {
		int jj1 = pass_justify(p1);
		nm_point(jj1, sx, sy, x1, y1, x2, y2);
	} else {
		*sx = 0.0; *sy = 0.0;
	}
}

void name_to_size(char *name, double *wd, double *hi) throw(ParserError) {
	double x1, y1, x2, y2;
	if (name_get(name, &x1, &y1, &x2, &y2)) {
		*wd = x2 - x1;
		*hi = y2 - y1;
	} else {
		*wd = 0.0; *hi = 0.0;
	}
}

void nm_point(int jj,double *rx, double *ry, double x1, double y1, double x2, double y2) {
	int jx,jy;
	double w,y,d;

	if ((jj == 0x2000)) { /* virtical */
		if (y2<*ry) *ry = y2;
		if (y1>*ry) *ry = y1;
		return;
	}
	if ((jj == 0x3000)) { /* horizontal centre   */
		if (x2<*rx) *rx = x2;
		if (x1>*rx) *rx = x1;
		return;
	}
	jx = (jj & 0xf0) / 16;
	jy = jj & 0x0f;
	d = jx * (x2-x1)/2;
	*rx = x1 + d;
	d = jy * (y2-y1)/2;
	*ry = y1 + d;
}

// What does this accomplish?
// What is justify.box? Not in manual?
void nm_adjust(int jj,double *sx, double *sy, double ex, double ey, double x1, double y1, double x2, double y2) {
	double r1,r2,xa,da,ca,dr,dx,dy,rz,r;
	if ((jj & 0xf000)==0x5000) {
		r1 = (x2-x1)/2;
		r2 = (y2-y1)/2;
			xy_polar(*sx - ex,*sy - ey,&dr,&da);
		xa = da - 180;
xxxa:		if (xa > 180) xa = xa - 180;
		if (xa < 0) xa = xa + 180;
		if ((xa<0) || (xa> 180)) goto xxxa;
		if (r1==0) return;
		ca = atan(r2/r1)*180/GLE_PI;
		if (xa < 90) {
			rz = r1/cos(GLE_PI*xa/180);
			if (xa>ca) rz = r2/sin(GLE_PI*xa/180);
		} else {
			xa = xa - 90;
			rz = r2/cos(GLE_PI*xa/180);
			if (xa>(90-ca)) rz = r1/sin(GLE_PI*xa/180);
		}
		dr = dr - rz ;
		polar_xy(dr,da,&dx,&dy);
		*sx = ex + dx;
		*sy = ey + dy;
	}
	if ((jj & 0xff00)==0x1000) {
		r = (x2-x1)/2;
		xy_polar(*sx-ex,*sy-ey,&dr,&da);
		dr = dr - r;
		polar_xy(dr,da,&dx,&dy);
		*sx = ex + dx;
		*sy = ey + dy;
	}
}

void nm_split(char *s, char *n, char *p) {
	char *d;
	d = strchr(s,'.');
	if (d!=0) {
		ncpy(n,s,d-s);
		strcpy(p,d+1);
	} else {
		strcpy(n,s);
		strcpy(p,"BO");
	}
}

int f_eof(int chn) {
	if (f_testchan(chn) == -1) return 1;
	else return (int)g_Files[chn]->eof();
}

void f_init() {
}

void siffree(char **s) {
	if (*s != NULL) myfree(*s);
	*s = NULL;
}

int f_testchan(int chn) {
	if (chn < 0 || chn >= g_Files.size() || g_Files[chn] == NULL) {
		gprint("Error in channel number %d\n",chn);
		return -1;
	}
	return chn;
}

void f_create_chan(int var, const char* fname, int rd_wr) {
	GLEFile* file = new GLEFile();
	int freechn = -1;
	for (int i = 0; i < g_Files.size() && freechn == -1; i++) {
		if (g_Files[i] == NULL) {
			freechn = i;
		}
	}
	if (freechn == -1) {
		freechn = g_Files.size();
		g_Files.push_back(file);
	} else {
		g_Files[freechn] = file;
	}
	file->setRdWr(rd_wr == 0 ? true : false);
	var_set(var, freechn);
	file->open(fname);
}

void f_close_chan(int idx) {
	if (f_testchan(idx) != -1) {
		GLEFile* file = g_Files[idx];
		file->close();
		delete file;
		g_Files[idx] = NULL;
	}
}

GLEFile::GLEFile() {
	m_ReadWrite = true;
	m_Output = NULL;
	m_Input = NULL;
}

GLEFile::~GLEFile() {
	close();
}

void GLEFile::close() {
	if (m_Output != NULL) {
		fclose(m_Output);
		m_Output = NULL;
	}
	if (m_Input != NULL) {
		m_Input->close_tokens();
		m_Input = NULL;
	}
}

void GLEFile::open(const char* fname) throw(ParserError) {
	if (isRead()) {
		m_Input = new StreamTokenizer();
		m_Input->open_tokens(fname);
		TokenizerLanguage* lang = m_Input->get_language();
		lang->setSpaceTokens(" ,\t\r\n");
		lang->setLineCommentTokens("!");
	} else {
		m_Output = fopen(fname, "w");
	}
}

char* GLEFile::readLine() throw(ParserError) {
	m_buffer = m_Input->read_line();
	return (char*)m_buffer.c_str();
}

char* GLEFile::getToken() throw(ParserError) {
	m_buffer = m_Input->next_token();
	str_remove_quote(m_buffer);
	return (char*)m_buffer.c_str();
}

void GLEFile::gotoNewLine() throw(ParserError) {
	m_Input->token_skip_to_end();
}

bool GLEFile::eof() throw(ParserError) {
	return m_Input->has_more_tokens() == 0 ? true : false;
}

void GLEFile::resetLang() {
	if (m_Input != NULL) {
		TokenizerLanguage* lang = m_Input->get_language();
		lang->resetCharMaps();
	}
}

void GLEFile::setLangChars(int type, const char* str) {
	if (m_Input != NULL) {
		char set[2];
		set[1] = 0;
		char prev_ch = -1;
		TokenizerLanguage* lang = m_Input->get_language();
		while ((*str) != 0) {
			char ch = str[0];
			bool ok = true;
			// Convert escape sequences in the string !
			if (prev_ch == '\\') {
				if (ch == 'n') ch = '\n';
				else if (ch == 't') ch = '\t';
				else if (ch == 'r') ch = '\r';
			} else if (ch == '\\') {
				ok = false;
			}
			if (ok) {
				set[0] = ch;
				switch (type) {
					case 0: lang->setLineCommentTokens(set); break;
					case 1: lang->setSpaceTokens(set); break;
					case 2: lang->setSingleCharTokens(set); break;
				}
			}
			prev_ch = ch;
			str++;
		}
	}
}
