#ifndef INCLUDE_SUB
#define INCLUDE_SUB

class GLESub {
protected:
	string m_Name;
	int m_Typ, m_Idx;
	vector<int> m_PType;
	vector<string> m_PName;
	int m_Start, m_End;
	GLEVarMap m_LocalVars;
public:
	GLESub();
	~GLESub();
	void addParam(const string& name, int type);
	void setStartEnd(int start, int end);
	void clear();
	inline const string& getName() const { return m_Name; }
	inline void setName(const string& name) { m_Name = name; }
	inline int getStart() const { return m_Start; }
	inline int getEnd() const { return m_End; }
	inline void setIndex(int idx) { m_Idx = idx; }
	inline int getIndex() const { return m_Idx; }
	inline GLEVarMap* getLocalVars() { return &m_LocalVars; }
	inline int getParamType(int idx) { return m_PType[idx]; }
	inline const string& getParamName(int idx) { return m_PName[idx]; }
	inline int getNbParam() { return m_PType.size(); }
	inline int* getParamTypes() { return &m_PType[0]; }
};

class GLESubMap {
protected:
	StringIntHash m_Map;
	vector<GLESub*> m_Subs;
public:
	GLESubMap();
	~GLESubMap();
	void clear();
	void GLESubMap::clear(int i);
	GLESub* add(const string& name);
	GLESub* get(const string& name);
	void list();
	inline GLESub* get(int i) { return m_Subs[i]; }
	inline int getIndex(const string& name) { return m_Map.try_get(name); }
	inline int size() { return m_Subs.size(); }
};

GLESub* sub_def(char *s);
GLESub* sub_find(const string& s);
void sub_param(GLESub* sub, char *s);

#endif
