
#pragma warning( disable : 4996 )
#ifndef STRINGKEYHASH_H
#define STRINGKEYHASH_H

#ifndef _MSC_VER
	// Use hash table except when compiling with MSVC
	#define GLE_USE_HASHTABLE
#endif

#define EXT_HASH
#ifdef _MSC_VER
	#undef EXT_HASH
#endif
#ifdef GCC2
	#undef EXT_HASH
#endif
#ifdef EXT_HASH
	#include <ext/hash_map>
#else
	#ifdef _MSC_VER
	#include <hash_map>
	using namespace stdext;
//	typedef hash _Hash;
	#else
	#include <hash_map.h>
	#endif
#endif
#include <algorithm>
#include <string>
#include <string.h>
#include <map>
#include <list>
#include <utility>
#include <iostream>

using namespace std;

#ifndef GCC2
#ifndef _MSC_VER
	using namespace __gnu_cxx;  // using gnu extensions such as "hash"
#endif
#endif

#include "RefCount.h"
#include "BinIO.h"

/**************************************************************************************************
 * Hash functions on strings                                                                      *
 **************************************************************************************************/

#define SKEYHASH_DELETE	1
#define SKEYHASH_KEEP   0

typedef string name_hash_key;

template <class ElemType> class StringKeyPair : public pair<const name_hash_key, ElemType> {
public:
	StringKeyPair(const name_hash_key key, ElemType value) : pair<const name_hash_key, ElemType>(key, value) {
	}
};

#ifdef GLE_USE_HASHTABLE

struct eq_name_hash_key {
	inline bool operator() (const name_hash_key& s1, const name_hash_key& s2) const {
	    return s1 == s2;
	}
};

struct hash_name_hash_key {
	inline size_t operator() (const name_hash_key& s) const {
		#ifdef _MSC_VER
		return stdext::hash_value<const char *>(s.c_str());
		#else
		return hash<const char *>()(s.c_str());
		#endif
	}
};

template <class ElemType> class StringKeyIterator : public hash_map<name_hash_key, ElemType>::iterator {
};

#else

struct lt_name_hash_key {
	bool operator()(const name_hash_key& s1, const name_hash_key& s2) const {
		return s1 < s2;
	}
};

#endif

/**************************************************************************************************
 * Hashtable string -> ElemType                                                                   *
 **************************************************************************************************/

template <class ElemType> class StringBasicHash :
#ifdef GLE_USE_HASHTABLE
	public hash_map<name_hash_key, ElemType, hash_name_hash_key, eq_name_hash_key> {
#else
	public map<name_hash_key, ElemType, lt_name_hash_key> {
#endif
};

/**************************************************************************************************
 * Hashtable string -> int (currently not used, might be used for variables?)                     *
 **************************************************************************************************/

#ifdef GLE_USE_HASHTABLE

class StringIntHash : public StringBasicHash<int> {
public:
	int try_get(const name_hash_key& key) const;
	void add_item(const name_hash_key& key, int elem);
};

#endif

/**************************************************************************************************
 * Hashtable string -> ElemType (used by the GLE parser)                                          *
 **************************************************************************************************/

template <class ElemType> class StringKeyHash :
#ifdef GLE_USE_HASHTABLE
    #ifdef _MSC_VER
	public hash_map<name_hash_key, ElemType , stdext::hash_compare<name_hash_key,eq_name_hash_key> > {
    #else
	public hash_map<name_hash_key, ElemType , hash_name_hash_key, eq_name_hash_key> {
    #endif
#else
	public map<name_hash_key, ElemType, lt_name_hash_key> {
#endif
public:
	ElemType try_add(const name_hash_key& key) {
		typename StringKeyHash<ElemType>::iterator i = this->find(key);
		if (i != this->end()) {
			return i->second;
		} else {
			ElemType nelem(key);
			insert(StringKeyPair<ElemType>(key, nelem));
			return nelem;
		}
	}

	ElemType try_get(const name_hash_key& key) {
		typename StringKeyHash<ElemType>::const_iterator i = this->find(key);
		if (i != this->end()) {
			return i->second;
		} else {
			return NULL;
		}
	}

	void add_item(const name_hash_key& key, const ElemType& elem) {
		insert(StringKeyPair<ElemType>(key, elem));
	}

	ostream& write(ostream &os, int tab) const {
		for (typename StringKeyHash<ElemType>::const_iterator i = this->begin(); i != this->end(); i++ ) {
			cerr << i->first << endl;
			i->second.write(os, tab);
		}
		return os;
	}

	ostream& writeKeys(ostream &os) const {
		for (typename StringKeyHash<ElemType>::const_iterator i = this->begin(); i != this->end(); i++ ) {
			cerr << i->first << endl;
		}
		return os;
	}
};

#endif // of #ifndef STRINGKEYHASH_H
