//
// var.cpp for GLE
//
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <math.h>
#include <vector>
#include <string>
#include <list>
using namespace std;
#include "SourceLine.h"

#include "all.h"
#include "mem_limits.h"
#include "token.h"
#include "tokens/Tokenizer.h"
#include "tokens/StringKeyHash.h"
#include "glearray.h"
#include "polish.h"
#include "pass.h"
#include "var.h"
#include "gprint.h"
#include "cutils.h"

#define true (!false)
#define false 0

/* hash tables for the global and local variables */

GLEVarMap  g_VarGlobal;
GLEVarMap* g_VarLocal = NULL;

/* global vars */

vector<double> var_val;
vector<string> var_str;

/* a stack */

static void *dp_stack[NUM_LOCAL];
static void *dp_stackstr[NUM_LOCAL];
static int   ndp;

/* local strings and values*/

static char  *(*lvar_str)[NUM_LOCAL];
static double (*lvar_val)[NUM_LOCAL];

GLEVarSubMap::GLEVarSubMap(GLEVarMap* parent) {
	m_Parent = parent;
}

GLEVarSubMap::~GLEVarSubMap() {
}

void GLEVarSubMap::clear() {
	m_Map.clear();
	m_Idxs.clear();
}

void GLEVarSubMap::var_add(const string& name, int idx) { 
	m_Map.add_item(name, idx);
	m_Idxs.push_back(idx);
}

void GLEVarSubMap::removeFromParent() {
	for (int i = 0; i < m_Idxs.size(); i++) {
		m_Parent->removeVar(m_Idxs[i]);
	}
}

GLEVarMap::GLEVarMap() {
	m_IsTemp = false;
}

GLEVarMap::~GLEVarMap() {
	clear();
}

int GLEVarMap::getFreeID() {
	if (m_Free.size() > 0) {
		int id = m_Free.back();
		m_Free.pop_back();
		return id;
	} else {
		return -1;
	}
}

int GLEVarMap::addVarIdx(const string& name) {
	int idx = getFreeID();
	int type = str_var(name) ? 2 : 1;
	if (idx != -1) {
		m_Names[idx] = name;
		m_Types[idx] = type;
	} else {
		idx = m_Names.size();
		m_Names.push_back(name);
		m_Types.push_back(type);
	}
	return idx;
}

int GLEVarMap::var_find_add(const string& name, bool* isnew) {
	*isnew = false;
	int idx = m_Map.try_get(name);
	if (idx == -1) {
		idx = addVarIdx(name);
		m_Map.add_item(name, idx);
		*isnew = true;
	}
	return idx;
}

int GLEVarMap::var_find_add_submap(const string& name, bool* isnew) {
	*isnew = false;
	GLEVarSubMap* sub = m_SubMap.back();
	int idx = sub->var_get(name);
	if (idx == -1) {
		idx = addVarIdx(name);
		sub->var_add(name, idx);
		*isnew = true;
	}
	return idx;
}

int GLEVarMap::var_get(const string& name) {
	int idx = -1;
	int submap = m_SubMap.size()-1;
	while (submap > 0 && (idx = m_SubMap[submap]->var_get(name)) == -1) {
		submap--;
	}
	if (idx != -1) return idx;
	else return m_Map.try_get(name);
}

const string& GLEVarMap::var_name(int idx) {
	return m_Names[idx];
}

void GLEVarMap::list() {
	for (int i = 0; i < m_Names.size(); i++) {
		if (m_Types[i] != -1) {
			cout << m_Names[i] << " (" << i << ")" << endl;
		}
	}
}

void GLEVarMap::removeVar(int idx) {
	m_Free.push_back(idx);
	m_Names[idx] = "?";
	m_Types[idx] = -1;
}

GLEVarSubMap* GLEVarMap::pushSubMap() {
	GLEVarSubMap* sub = new GLEVarSubMap(this);
	m_SubMap.push_back(sub);
	return sub;
}

void GLEVarMap::popSubMap() {
	GLEVarSubMap* sub = m_SubMap.back();
	sub->removeFromParent();
	delete sub;
	m_SubMap.pop_back();
}

void GLEVarMap::clearSubMaps() {
	for (int i = 0; i < m_SubMap.size(); i++) {
		delete m_SubMap[i];
		m_SubMap[i] = NULL;
	}
	m_SubMap.clear();
}

void GLEVarMap::clear() {
	m_Names.clear();
	m_Map.clear();
	clearSubMaps();
}

void expand_global_vars(int max) {
	string init_str = "";
	while (var_val.size() <= max) {
		var_val.push_back(0.0);
		var_str.push_back(init_str);
	}
}

bool var_check(int *j) {
	int var = *j;
	/* convert var index and return true if var is local */
	if (GLE_VAR_IS_LOCAL(var)) {
		var &= ~GLE_VAR_LOCAL_BIT;
		if (g_VarLocal == NULL) {
			gprint("No local variables assigned");
			*j = 0;
		} else if (var < 0 || var >= g_VarLocal->size() || var >= NUM_LOCAL) {
			gprint("Local variable index out of range: %d is not in 0-%d", var, g_VarLocal->size());
			*j = 0;
		} else {
			*j = var;
			return true;
		}
	} else {
		if (var < 0 || var >= g_VarGlobal.size()) {
			gprint("Global variable index out of range: %d is not in 0-%d", var, g_VarGlobal.size());
			*j = 0;
		}
	}
	return false;
}

void var_alloc_local() {
	ndp++;
	dp_stack[ndp]  = (void*) lvar_val;
	dp_stackstr[ndp] = (void*) lvar_str;
	lvar_val = (double (*)[NUM_LOCAL]) myallocz(sizeof(*lvar_val));
	lvar_str = (char* (*)[NUM_LOCAL]) myallocz(sizeof(*lvar_str));
}

void var_free_local() {
	if (ndp==0) {
		gprint("Cannot free local as none saved \n");
		return;
	}
	myfree(lvar_val);
	myfree(lvar_str);
	lvar_val = (double (*)[NUM_LOCAL]) dp_stack[ndp];
	lvar_str = (char* (*)[NUM_LOCAL]) dp_stackstr[ndp];
	ndp--;
}

void var_set(int jj, double v) {
	if (var_check(&jj)) {
		(*lvar_val)[jj] = v;
	} else {
		var_val[jj] = v;
	}
}

void var_setstr(int jj, char *s) {
	if (var_check(&jj)) {
		mystrcpy(&(*lvar_str)[jj],s);
	} else {
		var_str[jj] = s;
	}
}

void var_getstr(int jj, char *s) {
	const char* str = NULL;
	if (var_check(&jj)) {
		str = (*lvar_str)[jj];
	} else {
		str = var_str[jj].c_str();
	}
	if (str == NULL) {
		gprint("string variable not defined %d",jj);
		strcpy(s, "");
	} else {
		strcpy(s, str);
	}
}

void var_getstr(int jj, string& s) {
	const char* str = NULL;
	if (var_check(&jj)) {
		str = (*lvar_str)[jj];
	} else {
		str = var_str[jj].c_str();
	}
	if (str == NULL) {
		gprint("string variable not defined %d",jj);
		s = "";
	} else {
		s = str;
	}
}

void var_get(int jj, double *v) {
	if (var_check(&jj)) {
		*v = (*lvar_val)[jj];
	} else {
		*v = var_val[jj];
	}
}

char* var_get_name(int jj) {
	if (var_check(&jj)) {
		return (char*)g_VarLocal->var_name(jj).c_str();
	} else {
		return (char*)g_VarGlobal.var_name(jj).c_str();
	}
}

void var_nlocal(int *l) {
	*l = g_VarLocal == NULL ? 0 : g_VarLocal->size();
}

void var_clear_global() {
	g_VarGlobal.clear();
}

GLEVarMap* var_swap_local_map(GLEVarMap* map) {
	GLEVarMap* old = g_VarLocal;
	g_VarLocal = map;
	return old;
}

void var_set_local_map(GLEVarMap* map) {
	g_VarLocal = map;
}

void var_clear_local() {
	g_VarLocal = NULL;
}

void var_init(int idx, int type) {
	if (type == 1) var_set(idx, 0.0);
	else var_setstr(idx, "");
}

void var_def(char *s, double x) {
	int idx, type=1;
	var_findadd(s, &idx, &type);
	var_set(idx, x);
}

void var_findadd_set(char* name, double value) {
	int idx, type = 1;
	var_findadd(name, &idx, &type);
	var_set(idx, value);
}

void var_add_local(char *name, int *idx, int *type) {
	bool isnew;
	*idx = g_VarLocal->var_find_add(name, &isnew);
	*type = g_VarLocal->getType(*idx);
}

void var_findadd(char *name, int *idx, int *type) {
	bool isnew;
	if (g_VarLocal != NULL && g_VarLocal->hasSubMap()) {
		int l_idx = g_VarLocal->var_find_add_submap(name, &isnew);
		*type = g_VarLocal->getType(l_idx);
		*idx = l_idx | GLE_VAR_LOCAL_BIT;
		if (isnew) {
			var_init(*idx, *type);
		}
	} else {
		if (g_VarLocal != NULL) {
			int l_idx = g_VarLocal->var_get(name);
			if (l_idx != -1) {
				*type = g_VarLocal->getType(l_idx);
				*idx = l_idx | GLE_VAR_LOCAL_BIT;
				return;
			}
		}
		*idx = g_VarGlobal.var_find_add(name, &isnew);
		*type = g_VarGlobal.getType(*idx);
		if (isnew) {
			expand_global_vars(*idx);
			var_init(*idx, *type);
		}
	}
}

// First search in local vars, then in global vars
void var_find(char *name, int *idx, int *type) {
	*idx = -1;
	if (g_VarLocal != NULL) {
		int l_idx = g_VarLocal->var_get(name);
		if (l_idx != -1) {
			*type = g_VarLocal->getType(l_idx);
			*idx = l_idx | GLE_VAR_LOCAL_BIT;
			return;
		}
	}
	int g_idx = g_VarGlobal.var_get(name);
	if (g_idx != -1) {
		*type = g_VarGlobal.getType(g_idx);
		*idx = g_idx;
	}
}

GLEVarSubMap* var_add_local_submap() {
	if (g_VarLocal == NULL) {
		g_VarLocal = new GLEVarMap();
		g_VarLocal->setTemp(true);
		var_alloc_local();
	}
	return g_VarLocal->pushSubMap();
}

void var_remove_local_submap() {
	if (g_VarLocal != NULL) {
		if (g_VarLocal->isTemp()) {
			delete g_VarLocal;
			g_VarLocal = NULL;
			var_free_local();
		} else {
			g_VarLocal->popSubMap();	
		}
	}
}

void var_find_dn(GLEVarSubMap* map, int *idx, int *var, int *nd) {
	*nd = 0;
	for (int i = 0; i < map->size(); i++) {
		int lidx = map->get(i);
		const string& name = g_VarLocal->var_name(lidx);
		if (str_ni_equals(name.c_str(), "D", 1)) {
			int d = atoi(name.c_str()+1);	
			// cout << "name = " << name << " idx = " << d << endl;
			if (d > 0 && d < 100) {
				*idx = lidx | GLE_VAR_LOCAL_BIT;
				*var = d;
				(*nd)++; idx++; var++;
			}
		}
	}
	// cout << "res = " << *nd << endl;
}

bool str_var(const char* s) {
	int i = strlen(s);
	if (*(s+i-1)=='$') return true;
	else return false;
}

bool str_var(const string& s) {
	if (s[s.length()-1] == '$') return true;
	else return false;
}

int valid_var(char* s) {
	return true;
}

bool var_valid_name(const string& name) {
	if (name.length() == 0) {
		return false;
	} else {
		int ch = name[0];
		if (!((ch >= 'A' && ch <= 'Z') || (ch >= 'a' && ch <= 'z'))) {
			return false;
		} else {
			return true;
		}
	}
}
